/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.chassis;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.RenderingHints.Key;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Map;

public class DebugGraphics extends GraphicsAdapter {

    public final PrintStream o;
    
    public DebugGraphics(Graphics2D g, PrintStream out)
    {
        super(g);
        this.o = out;
    }

    public DebugGraphics(Graphics2D g)
    {
        super(g);
        this.o = System.out;
    }

    public void print(Object ... args)
    {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        o.print( e[2].getMethodName() );
        if (args!=null && args.length>0) {
            o.print(Arrays.toString(args));
        }
        o.println();
    }
    
    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        print();
        super.addRenderingHints(hints);
    }

    @Override
    public void clip(Shape s) {
        print();
        super.clip(s);
    }

    @Override
    public void draw(Shape s) {
        print(s);
        super.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        super.drawGlyphVector(g, x, y);
        print(g, x, y);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        print(img, xform, obs);
        return g.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        print(img, op, x, y);
        super.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        print(img, xform);
        super.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        print(img, xform);
        super.drawRenderedImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        print(str, x, y);
        super.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        print(str, x, y);
        super.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        print(iterator, x, y);
        super.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        print(iterator, x, y);
        super.drawString(iterator, x, y);
    }

    @Override
    public void fill(Shape s) {
        print(s);
        super.fill(s);
    }

    @Override
    public Color getBackground() {
        print();
        return g.getBackground();
    }

    @Override
    public Composite getComposite() {
        print();
        return g.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        print();
        return g.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        print();
        return g.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        print();
        return g.getPaint();
    }

    @Override
    public Object getRenderingHint(Key hintKey) {
        print(hintKey);
        return g.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        print();
        return g.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        print();
        return g.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        print();
        return g.getTransform();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        print(rect, s, onStroke);
        return g.hit(rect, s, onStroke);
    }

    @Override
    public void rotate(double theta) {
        print(theta);
        super.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        print(theta, x, y);
        super.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        print(sx, sy);
        super.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        print(color);
        super.setBackground(color);
    }

    @Override
    public void setComposite(Composite comp) {
        print(comp);
        super.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        print(paint);
        super.setPaint(paint);
    }

    @Override
    public void setRenderingHint(Key hintKey, Object hintValue) {
        print(hintKey, hintValue);
        super.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) { 
        print(hints);
        super.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        print(s);
        super.setStroke(s);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        print(Tx);
        super.setTransform(Tx);
    }

    @Override
    public void shear(double shx, double shy) {
        print(shx, shy);
        super.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        print(Tx);
        super.transform(Tx);
    }

    @Override
    public void translate(int x, int y) {
        print(x, y);
        super.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        print(tx, ty);
        super.translate(tx, ty);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.clearRect(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.clearRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        print(x, y, width, height, dx, dy);
        super.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        print();
        return new DebugGraphics((Graphics2D) g.create());
    }

    @Override
    public void dispose() {
        print();
        super.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        print(x, y, width, height, startAngle, arcAngle);
        super.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        print(img, x, y, observer);
        return g.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        print(img, x, y, bgcolor, observer);
        return g.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        print(img, x, y, width, height, observer);
        return g.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        print(img, x, y, width, height, bgcolor, observer);
        return g.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2,
            ImageObserver observer) {        
        print(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        return g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2,
            Color bgcolor, ImageObserver observer) {
        print(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        return g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        print(x1, y1, x2, y2);
        super.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] points, int[] points2, int points3) {
        print(points, points2, points3);
        super.drawPolygon(points, points2, points3);
    }

    @Override
    public void drawPolyline(int[] points, int[] points2, int points3) {
        print(points, points2, points3);
        super.drawPolyline(points, points2, points3);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        print(x, y, width, height, arcWidth, arcHeight);
        super.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        print(x, y, width, height, startAngle, arcAngle);
        super.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] points, int[] points2, int points3) {
        print(points, points2, points3);
        super.fillPolygon(points, points2, points3);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        print(x, y, width, height, arcWidth, arcHeight);
        super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Shape getClip() {
        print();
        return g.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        print();
        return g.getClipBounds();
    }

    @Override
    public Color getColor() {
        print();
        return g.getColor();
    }

    @Override
    public Font getFont() {
        print();
        return g.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        print();
        return g.getFontMetrics(f);
    }

    @Override
    public void setClip(Shape clip) {
        print(clip);
        super.setClip(clip);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        print(x, y, width, height);
        super.setClip(x, y, width, height);
    }

    @Override
    public void setColor(Color c) {
        print(c);
        super.setColor(c);
    }

    @Override
    public void setFont(Font font) {
        print(font);
        super.setFont(font);
    }

    @Override
    public void setPaintMode() {
        print();
        super.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        print(c1);
        super.setXORMode(c1);
    }

}
