/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.chassis;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

/**
 * @author Toni Kalajainen
 */
public abstract class AbstractChassis implements ICanvasChassis {

    /** Hint context */
    protected IHintContext                        hintCtx   = new HintContext();
    
    protected SyncListenerList<IChassisListener>  listeners = new SyncListenerList<IChassisListener>(IChassisListener.class);
    
    protected ICanvasContext                      canvasContext;
    
    public void setCanvasContext(ICanvasContext canvasContext) {
        assert (this.canvasContext == null);
        assert (canvasContext != null);
        this.canvasContext = canvasContext;
        // Create canvas context and a layer of interactors
        canvasContext.getHintStack().addHintContext(hintCtx, 0);
    }
    
    @Override
    public ICanvasContext getCanvasContext() {
        return canvasContext;
    }
    
    @Override
    public void addChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        listeners.add(thread, listener);
    }

    @Override
    public void removeChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        listeners.remove(thread, listener);
    }

    @Override
    public void addChassisListener(IChassisListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeChassisListener(IChassisListener listener) {
        listeners.remove(listener);
    }    

    @Override
    public IHintContext getHintContext() {
        return hintCtx;
    }
    
}
