/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas.impl;

import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.canvas.IMouseCaptureHandleListener;
import org.simantics.utils.datastructures.ListenerList;

/**
 * @author Toni Kalajainen
 */
public class MouseCaptureHandle implements IMouseCaptureHandle {

    boolean released = false;
    final int mouseId;
    ListenerList<IMouseCaptureHandleListener> listeners;

    public MouseCaptureHandle(int mouseId) 
    {
        this.mouseId = mouseId;
    }
    
    @Override
    public int mouseId() {
        return mouseId;
    }

    @Override
    public void release() {
        synchronized(this) {
            if (released) return;
            released = true;
        }
        fireOnReleased();
    }

    void fireOnReleased() {
        ListenerList<IMouseCaptureHandleListener> lis;
        synchronized(this) {
            lis = listeners;
            if (lis==null) return;
        }
        
        for (IMouseCaptureHandleListener l : lis.getListeners())
            l.onCaptureReleased(this);
    }

    @Override
    public void removeMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {    
        if (listeners == null) return;
        listeners.remove(listener);
    }

    @Override
    public synchronized void addMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {
        if (listeners == null) {
            listeners = new ListenerList<IMouseCaptureHandleListener>(IMouseCaptureHandleListener.class);
        }
        listeners.add(listener);
    }
    
}
