/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas;

import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * @See MouseCaptureHandle for an implementation
 * @author Toni Kalajainen
 */
public interface IMouseCaptureContext {

    /**
     * Captures mouse events even when mouse leaves the control area. 
     * 
     * @param mouseId
     */
    IMouseCaptureHandle captureMouse(int mouseId);  
    
    void addMouseCaptureListener(IMouseCaptureListener listener);
    void addMouseCaptureListener(IMouseCaptureListener listener, IThreadWorkQueue thread);
    void removeMouseCaptureListener(IMouseCaptureListener listener);
    void removeMouseCaptureListener(IMouseCaptureListener listener, IThreadWorkQueue thread);    
    
}
