/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas;

import org.simantics.g2d.canvas.impl.PaintableContextImpl;
import org.simantics.utils.threads.IThreadWorkQueue;


/**
 * 
 * @See {@link PaintableContextImpl}
 * @author Toni Kalajainen
 */
public interface IContentContext {

	
    /**
     * Marks the canvas dirty. It will be repainted later. 
     */
    void setDirty();
    void addPaintableContextListener(IContentListener listener);
    void addPaintableContextListener(IContentListener listener, IThreadWorkQueue thread);    
    void removePaintableContextListener(IContentListener listener);        
    void removePaintableContextListener(IContentListener listener, IThreadWorkQueue thread);        
    
    public interface IContentListener {

        /** 
         * Notification for canvas becoming dirty
         * 
         * @param sender the context
         */
        public void onDirty(IContentContext sender);    
    }    
    
}
