/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.graphfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.PartInitException;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.Activator;
import org.simantics.document.ui.graphfile.Messages;
import org.simantics.editors.Editors;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.ui.workbench.editor.IEditorRegistry;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalEditorAdapter.class);
    private static final Map<Path, Resource> tempFiles = new ConcurrentHashMap<Path, Resource>();
    private static ExternalFileWatcher fileWatcher;
    private static final int PREFERRED_PRIORITY = 0x40000000;
    private static final int MAX_FILENAME_LENGTH = 255;
    private static final int MAX_DIRNAME_LENGTH = 255;
    private IEclipsePreferences defaultPreferenceNode;
    private IEclipsePreferences instancePreferenceNode;
    private boolean isPreferredAdapter = false;
    IEclipsePreferences.IPreferenceChangeListener preferenceListener = event -> {
        String key = event.getKey();
        if (key.equals("documents.preferExternalEditorForEmbeddedDocuments")) {
            boolean preferred = this.getIsPreferredAdapterPreference();
            if (preferred == this.isPreferredAdapter) {
                return;
            }
            this.isPreferredAdapter = preferred;
            IEditorRegistry er = EditorRegistry.getInstance();
            er.getMappings().clear();
            er.clearCache();
        }
    };

    private boolean getIsPreferredAdapterPreference() {
        boolean def = this.defaultPreferenceNode.getBoolean("documents.preferExternalEditorForEmbeddedDocuments", false);
        return this.instancePreferenceNode.getBoolean("documents.preferExternalEditorForEmbeddedDocuments", def);
    }

    public ExternalEditorAdapter() {
        super(Messages.ExternalEditorAdapter_ExternalEditor, Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/page.png"));
        this.defaultPreferenceNode = DefaultScope.INSTANCE.getNode("org.simantics.document.ui");
        this.instancePreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.document.ui");
        this.isPreferredAdapter = this.getIsPreferredAdapterPreference();
        this.instancePreferenceNode.addPreferenceChangeListener(this.preferenceListener);
    }

    public int getPriority() {
        if (this.isPreferredAdapter) {
            return 0x40000000;
        }
        return super.getPriority();
    }

    public void setPriority(int priority) {
        super.setPriority(priority);
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)g);
        return g.isInstanceOf(r, doc.FileDocument);
    }

    protected void openEditor(final Resource input) throws Exception {
        Path path = null;
        for (Map.Entry<Path, Resource> entry : tempFiles.entrySet()) {
            Resource value = entry.getValue();
            if (!input.equals(value)) continue;
            path = entry.getKey();
        }
        if (path == null) {
            path = (Path)Simantics.getSession().syncRequest((Read)new UniqueRead<Path>(){

                public Path perform(ReadGraph graph) throws DatabaseException {
                    GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                    File root = new File(Platform.getInstanceLocation().getURL().getPath(), "tempFiles/external");
                    Variable v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)input);
                    String relativePath = null;
                    if (v != null) {
                        externalFilePath = (String)v.getPossiblePropertyValue(graph, GF.ExternalFilePath);
                        if (externalFilePath != null) {
                            relativePath = ExternalEditorAdapter.sanitizePath(new File(externalFilePath)).getPath();
                        }
                    } else {
                        externalFilePath = (String)graph.getPossibleRelatedValue(input, GF.ExternalFilePath);
                        if (externalFilePath != null) {
                            relativePath = ExternalEditorAdapter.sanitizePath(new File(externalFilePath)).getPath();
                        }
                    }
                    if (relativePath == null) {
                        relativePath = graph.getPossibleRelatedValue(input, Layer0.getInstance((ReadGraph)graph).HasName).toString();
                        relativePath = relativePath != null ? ExternalEditorAdapter.sanitizeName(relativePath, false) : "Untitled";
                    }
                    File file = new File(root, relativePath);
                    String name = file.getName();
                    int pos = name.lastIndexOf(46);
                    String ext = "";
                    String base = name;
                    if (pos != -1) {
                        ext = name.substring(pos);
                        base = name.substring(0, pos);
                    }
                    File dir = file.getParentFile();
                    String shortenedName = ExternalEditorAdapter.shortenFileName(base, ext, 1);
                    file = new File(dir, shortenedName);
                    int i = 2;
                    while (file.exists()) {
                        shortenedName = ExternalEditorAdapter.shortenFileName(base, ext, i);
                        file = new File(dir, shortenedName);
                        ++i;
                    }
                    try {
                        dir.mkdirs();
                        ExternalEditorAdapter.watch(dir.toPath());
                        File finalFile = file;
                        tempFiles.compute(finalFile.toPath(), (t, y) -> {
                            try {
                                GraphFileUtil.writeDataToFile((ReadGraph)graph, (Resource)input, (File)t.toFile());
                            }
                            catch (IOException | DatabaseException e) {
                                LOGGER.error("Could not write data to file ", e);
                            }
                            return input;
                        });
                        LOGGER.info("Adding tempFile {} with resource {}", (Object)file, (Object)input);
                        return file.toPath();
                    }
                    catch (IOException e2) {
                        ExceptionUtils.logAndShowError((Throwable)e2);
                        return null;
                    }
                }
            });
        }
        if (path != null) {
            try {
                Editors.openExternalEditor((File)path.toFile());
            }
            catch (PartInitException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
        }
    }

    private static File sanitizePath(File f) {
        return ExternalEditorAdapter.sanitizePath(f, false);
    }

    private static File sanitizePath(File f, boolean isDir) {
        String fileName = ExternalEditorAdapter.sanitizeName(f.getName(), isDir);
        File parent = f.getParentFile();
        if (parent != null) {
            return new File(ExternalEditorAdapter.sanitizePath(parent, true), fileName);
        }
        return new File(fileName);
    }

    private static String shortenFileName(String baseName, String ext, int variant) {
        String num = variant != 1 ? Integer.toString(variant) : "";
        String shortenedBase = baseName;
        if (baseName.length() + num.length() + ext.length() > 255) {
            if (num.length() + ext.length() > 255) {
                ext = ext.substring(0, 255 - num.length());
            }
            shortenedBase = shortenedBase.substring(0, 255 - num.length() - ext.length());
        }
        return shortenedBase + num + ext;
    }

    private static String sanitizeName(String name, boolean isDir) {
        name = ((String)name).replaceAll("(?i)^(con|prn|aux|nul|com[0-9]|lpt[0-9])(\\.[^.]*)?$", "$1_");
        name = ((String)name).replaceAll("[<>:\"\\/|?*\\x00-\\x1F]", "_");
        name = ((String)name).replaceAll("^(.*[\\. ])$", "$1_");
        if (isDir && ((String)name).length() > 255) {
            name = ((String)name).substring(0, 254) + "_";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void watch(Path path) throws IOException {
        Class<ExternalEditorAdapter> clazz = ExternalEditorAdapter.class;
        synchronized (ExternalEditorAdapter.class) {
            if (fileWatcher == null) {
                fileWatcher = new ExternalFileWatcher();
            }
            fileWatcher.register(path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopFileWatcher() {
        Class<ExternalEditorAdapter> clazz = ExternalEditorAdapter.class;
        synchronized (ExternalEditorAdapter.class) {
            tempFiles.clear();
            if (fileWatcher != null) {
                fileWatcher.stop();
                fileWatcher = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    static /* synthetic */ Map access$1() {
        return tempFiles;
    }

    static class ExternalFileWatcher {
        private ExecutorService service = Executors.newFixedThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        private final WatchService ws;
        private final AtomicBoolean stopped = new AtomicBoolean(true);
        private ConcurrentHashMap<WatchKey, Path> keys = new ConcurrentHashMap();

        public ExternalFileWatcher() throws IOException {
            this.ws = FileSystems.getDefault().newWatchService();
            this.service.submit(() -> {
                this.stopped.set(false);
                while (!this.stopped.get()) {
                    try {
                        WatchKey key = this.ws.take();
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            if (StandardWatchEventKinds.OVERFLOW == watchEvent.kind()) continue;
                            WatchEvent<?> pathEvent = watchEvent;
                            WatchEvent.Kind<?> kind = pathEvent.kind();
                            Path parent = this.keys.get(key);
                            Path newPath = parent.resolve((Path)pathEvent.context());
                            if (Files.exists(newPath, LinkOption.NOFOLLOW_LINKS)) {
                                if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                                    LOGGER.info("New path modified: {}", (Object)newPath);
                                    Resource resource = tempFiles.get(newPath);
                                    if (resource != null) {
                                        GraphFileUtil.writeDataToGraph((File)newPath.toFile(), (Resource)resource);
                                        continue;
                                    }
                                    LOGGER.warn("No resource found for {}", (Object)newPath.toAbsolutePath());
                                    continue;
                                }
                                if (StandardWatchEventKinds.ENTRY_DELETE != kind) continue;
                                LOGGER.info("New path deleted: {}", (Object)newPath);
                                continue;
                            }
                            tempFiles.remove(newPath);
                            key.cancel();
                        }
                        if (key.reset()) continue;
                        this.keys.remove(key);
                    }
                    catch (InterruptedException e) {
                        if (this.stopped.get()) continue;
                        LOGGER.error("Could not stop", (Throwable)e);
                    }
                    catch (Throwable t) {
                        LOGGER.error("An error occured", t);
                    }
                }
            });
        }

        public void stop() {
            this.stopped.set(true);
        }

        public void register(Path path) throws IOException {
            if (Files.isDirectory(path, new LinkOption[0])) {
                LOGGER.info("Registering path {}", (Object)path);
                WatchKey key = path.toAbsolutePath().register(this.ws, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.keys.put(key, path);
            }
        }
    }
}

