/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.TabContribution;
import org.simantics.utils.ui.ExceptionUtils;

public class AnnotationConfigurator {
    private Resource type;
    private Resource lib;
    boolean useVG = false;
    Variable annotationHolderVariable;

    public AnnotationConfigurator(Resource type, Resource lib) {
        this.type = type;
        this.lib = lib;
    }

    public void createComposite(Composite parent) {
        this.annotationHolderVariable = this.createAnnotationHolder2();
        IWorkbenchSite site = null;
        Collection<ComparableTabContributor> contribution = this.getAnnotationTab(this.annotationHolderVariable);
        StructuredSelection selection = new StructuredSelection((Object)this.annotationHolderVariable);
        for (ComparableTabContributor c : contribution) {
            IPropertyTab tab = c.create(parent, site, Simantics.getSessionContext(), (Object)selection);
            tab.setInput(Simantics.getSessionContext(), (ISelection)selection, false);
        }
    }

    private Variable createAnnotationHolder2() {
        VirtualGraph vg = null;
        if (this.useVG) {
            VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
            vg = support.getMemoryPersistent("document_annotation");
        }
        Variable annotationHolder = null;
        try {
            annotationHolder = (Variable)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Variable>(vg){

                public Variable perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource annotationHolderDoc = graph.newResource();
                    graph.claim(annotationHolderDoc, l0.InstanceOf, AnnotationConfigurator.this.type);
                    graph.claimLiteral(annotationHolderDoc, l0.HasName, (Object)"Template");
                    graph.claim(AnnotationConfigurator.this.lib, l0.ConsistsOf, annotationHolderDoc);
                    if (graph.isInstanceOf(AnnotationConfigurator.this.lib, AnnotationConfigurator.this.type)) {
                        AnnotationConfigurator.this.copyAnnotations(graph, AnnotationConfigurator.this.lib, annotationHolderDoc);
                    }
                    return (Variable)graph.adapt(annotationHolderDoc, Variable.class);
                }
            });
        }
        catch (DatabaseException e1) {
            ExceptionUtils.logAndShowError((Throwable)e1);
        }
        return annotationHolder;
    }

    private Collection<ComparableTabContributor> getAnnotationTab(final Object selection) {
        try {
            return (Collection)Simantics.getSession().syncRequest((Read)new Read<Collection<ComparableTabContributor>>(){

                public Collection<ComparableTabContributor> perform(ReadGraph graph) throws DatabaseException {
                    AnnotationResource ann = AnnotationResource.getInstance((ReadGraph)graph);
                    TabContribution contribution = (TabContribution)graph.adapt(ann.SelectionTabContribution, TabContribution.class);
                    ArrayList<ComparableTabContributor> coll = new ArrayList<ComparableTabContributor>();
                    contribution.contribute(graph, selection, coll);
                    return coll;
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return null;
        }
    }

    public void apply(final Resource to) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                AnnotationConfigurator.this.apply(graph, to);
            }
        });
    }

    public void apply(WriteGraph graph, Resource to) throws DatabaseException {
        Resource from = this.annotationHolderVariable.getPossibleRepresents((ReadGraph)graph);
        this.copyAnnotations(graph, from, to);
    }

    private void copyAnnotations(WriteGraph graph, Resource from, Resource to) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ann = AnnotationResource.getInstance((ReadGraph)graph);
        ArrayList<Statement> annotations = new ArrayList<Statement>();
        for (Statement s : graph.getStatements(from, l0.HasProperty)) {
            if (!graph.isInstanceOf(s.getObject(), ann.Annotation)) continue;
            annotations.add(s);
        }
        for (Statement annotation : annotations) {
            Resource annotationInstance = graph.newResource();
            graph.claim(to, annotation.getPredicate(), annotationInstance);
            for (Resource type : graph.getObjects(annotation.getObject(), l0.InstanceOf)) {
                graph.claim(annotationInstance, l0.InstanceOf, type);
            }
            for (Statement property : graph.getStatements(annotation.getObject(), l0.HasProperty)) {
                if (property.isAsserted(annotation.getObject())) continue;
                graph.claimLiteral(annotationInstance, property.getPredicate(), graph.getValue(property.getObject()));
            }
        }
    }

    public void dispose() {
        if (this.useVG) {
            VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
            VirtualGraph vg = support.getMemoryPersistent("document_annotation");
            support.discard(vg);
        } else {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource r = AnnotationConfigurator.this.annotationHolderVariable.getPossibleRepresents((ReadGraph)graph);
                    graph.deny(r);
                }
            });
        }
    }
}

