/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.File;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.actions.Messages;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportDocumentFile
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String name = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
                            GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                            if (!graph.isInstanceOf(resource, doc.FileDocument)) {
                                return null;
                            }
                            String resourceName = (String)graph.getPossibleRelatedValue(resource, gf.HasResourceName);
                            if (resourceName != null) {
                                return resourceName;
                            }
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            return (String)graph.getPossibleRelatedValue(resource, L0.HasName);
                        }
                    });
                    FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                    dialog.setFileName(name);
                    String filename = dialog.open();
                    if (filename == null) {
                        return;
                    }
                    ExportDocumentFile.exportDocument(resource, filename);
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)Messages.ExportDocumentFile_CannotExportDocument, (Throwable)e);
                }
            }
        };
    }

    public static void exportDocument(Resource document, String fileName) throws DatabaseException {
        GraphFileUtil.writeDataToFile((Resource)document, (File)new File(fileName));
    }
}

