/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.function;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.FunctionImpl5;
import org.simantics.workbench.search.NameRow;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.SearchResultRow;
import org.simantics.workbench.search.Searching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFunction
extends FunctionImpl5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchFunction.class);

    public SearchResult apply(IProgressMonitor monitor, ReadGraph graph, Resource model, SearchQuery query, Integer maxResults) {
        try {
            Collection results = Searching.performSearch((ReadGraph)graph, (Resource)Layer0X.getInstance((ReadGraph)graph).Dependencies, (Resource)model, (String)query.escapedWithForcedCase(false, false).getQuery(new String[]{"NameSearch", "TypesSearch"}), (int)maxResults);
            return SearchFunction.generateSearchResults(graph, results);
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to generate document link search results", (Throwable)e);
            return null;
        }
    }

    public static final SearchResult generateSearchResults(ReadGraph graph, Collection<Map<String, Object>> results) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        SearchResult result = new SearchResult(NameRow.columns);
        HashSet<Resource> processed = new HashSet<Resource>();
        for (Map<String, Object> r : results) {
            Resource p;
            Resource resource = (Resource)r.get("Resource");
            if (!graph.isInstanceOf(resource, doc.Document) || !processed.add(resource)) continue;
            Resource parent = (Resource)r.get("Parent");
            String name = (String)r.get("Name");
            if (resource.equals(parent) && (p = graph.getPossibleObject(resource, l0.PartOf)) != null) {
                parent = p;
            }
            NameRow rst = new NameRow();
            rst.resource = NamedResource.of((ReadGraph)graph, (Resource)resource, (String)name);
            rst.parent = NamedResource.of((ReadGraph)graph, (Resource)parent);
            result.addRow((SearchResultRow)rst);
        }
        return result;
    }
}

