/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.IOException;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;

public class NewFileDocument
implements ActionFactory {
    Resource relation;
    String defaultName;

    public NewFileDocument(ReadGraph graph, String relationUri, String defaultName) throws DatabaseException {
        this.relation = graph.getResource(relationUri);
        this.defaultName = defaultName;
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        NewFileDocument.create(graph, resource, (this).NewFileDocument.this.relation, (this).NewFileDocument.this.defaultName);
                    }
                });
            }
        };
    }

    public static Resource create(WriteGraph graph, Resource resource, Resource relation, String defaultName) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)defaultName, (Resource)resource, (Resource)relation);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        Resource fileResource = graph.newResource();
        graph.claim(fileResource, l0.InstanceOf, doc.FileDocument);
        graph.claimLiteral(fileResource, l0.HasName, (Object)name);
        graph.claim(resource, relation, fileResource);
        try {
            GraphFileUtil.writeDataToGraph((WriteGraph)graph, (byte[])new byte[0], (Resource)fileResource);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        return fileResource;
    }
}

