/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.document.ui.Messages;
import org.simantics.document.ui.prefs.DocumentsPreferences;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.views.swt.ModelledView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentView
extends ModelledView {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentView.class);
    private boolean pinSelection = false;
    private ShowEditor showEditor;
    private IEclipsePreferences documentPreferenceNode;
    private IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("documents.documentationViewEditorVisible".equals(event.getKey())) {
                boolean editorVisible = DocumentView.this.documentPreferenceNode.getBoolean("documents.documentationViewEditorVisible", true);
                DocumentView.this.showEditor.setChecked(editorVisible);
                DocumentView.this.showEditor.simulateClick();
            }
        }
    };

    protected String configurationURI() {
        return "http://www.simantics.org/DocumentUI-1.1/View";
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }

    protected void inputChanged(IWorkbenchPart provider, Object input) {
        if (this.pinSelection) {
            return;
        }
        super.inputChanged(provider, input);
    }

    public void fireInput() {
        super.fireInput();
        this.scheduleUIRefresh();
    }

    public void scheduleUIRefresh() {
        Simantics.getSession().asyncRequest(g -> {
            SWTUtils.asyncExec((Widget)this.body, () -> {
                if (!this.body.isDisposed()) {
                    this.showEditor.runWithoutUserInteraction();
                }
            });
            return null;
        });
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)new PinSelection());
        this.showEditor = new ShowEditor(DocumentsPreferences.getPreferences().documentationViewEditorVisible);
        tbm.add((IAction)this.showEditor);
        this.documentPreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.document.ui");
        this.documentPreferenceNode.addPreferenceChangeListener(this.preferenceListener);
    }

    public void dispose() {
        if (this.documentPreferenceNode != null) {
            this.documentPreferenceNode.removePreferenceChangeListener(this.preferenceListener);
        }
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Control> T findControl(Control from, Class<T> clazz) {
        if (clazz.isInstance(from)) {
            return (T)from;
        }
        Control control = from;
        if (control instanceof Composite) {
            void comp;
            Composite composite = (Composite)control;
            Composite cfr_ignored_0 = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T r = DocumentView.findControl(child, clazz);
                if (r != null) {
                    return r;
                }
                ++n2;
            }
        }
        return null;
    }

    private class PinSelection
    extends Action {
        public PinSelection() {
            super(Messages.DocumentView_PinSelection, 2);
            this.setImageDescriptor(BundleUtils.getImageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/elcl16/pin_view.png"));
        }

        public void run() {
            DocumentView.this.pinSelection = this.isChecked();
        }
    }

    private class ShowEditor
    extends Action {
        public ShowEditor(boolean initialState) {
            super("Show Documentation Editor", 2);
            this.setImageDescriptor(BundleUtils.getImageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/etool16/editor_area.png"));
            this.setChecked(initialState);
        }

        public void runWithEvent(Event event) {
            this.restoreMaximizedState(false);
            DocumentsPreferences prefs = DocumentsPreferences.getPreferences();
            prefs.documentationViewEditorVisible = this.isChecked();
            try {
                prefs.storePreferences();
            }
            catch (IOException e) {
                LOGGER.error("Failed to persist Documentation preferences in instance scope", (Throwable)e);
            }
        }

        public void run() {
            this.restoreMaximizedState(true);
        }

        public void runWithoutUserInteraction() {
            this.run();
        }

        public void simulateClick() {
            this.restoreMaximizedState(false);
        }

        boolean restoreMaximizedState(boolean setCheckedByPreference) {
            SashForm sf = DocumentView.findControl((Control)DocumentView.this.container, SashForm.class);
            LOGGER.trace("sashform: {}", (Object)sf);
            if (sf != null) {
                Object[] children = sf.getChildren();
                LOGGER.trace("children: {}", (Object)Arrays.toString(children));
                if (children.length == 3 && children[0] instanceof Browser && children[1] instanceof Composite && children[2] instanceof Sash) {
                    DocumentsPreferences prefs = DocumentsPreferences.getPreferences();
                    if (setCheckedByPreference) {
                        LOGGER.trace("set editor visible by preference: {}", (Object)prefs);
                        this.setChecked(prefs.documentationViewEditorVisible);
                        sf.setMaximizedControl(prefs.documentationViewEditorVisible ? null : children[0]);
                    } else {
                        boolean editorVisible = this.isChecked();
                        LOGGER.trace("set editor visible: {}", (Object)editorVisible);
                        sf.setMaximizedControl(editorVisible ? null : children[0]);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

