/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.simantics.document.ui.Activator;
import org.simantics.document.ui.CSSCompletionAssistProcessor;
import org.simantics.document.ui.CSSEditorTextHover;
import org.simantics.document.ui.CSSTextEditorEnvironment;

public class CSSSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final char[] CONTENT_ASSIST_AUTO_CHARS = new char[]{'.'};
    Device device;
    ISharedTextColors sharedTextColors;
    IPreferenceStore preferenceStore;
    private CSSTextEditorEnvironment editorEnvironment;
    private static final IInformationControlCreator CREATOR = new IInformationControlCreator(){

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    };

    public CSSSourceViewerConfiguration(Device device, ISharedTextColors sharedTextColors) {
        this.device = device;
        this.sharedTextColors = sharedTextColors;
        this.preferenceStore = EditorsUI.getPreferenceStore();
        this.editorEnvironment = new CSSTextEditorEnvironment();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.preferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.preferenceStore.getInt("tabWidth");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentPrefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
        if (indentPrefixes == null) {
            return null;
        }
        int length = indentPrefixes.length;
        if (length > 2) {
            String first = indentPrefixes[0];
            indentPrefixes[0] = indentPrefixes[length - 2];
            indentPrefixes[length - 2] = first;
        }
        return indentPrefixes;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getSclTokenScanner());
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    ITokenScanner getSclTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        Font font = (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((String)"Courier New", (int)10, (int)0));
        Font boldFont = (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((String)"Courier New", (int)10, (int)1));
        Token defaultToken = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(0, 0, 0)), null, 0, font));
        Token string = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(42, 0, 255)), null, 0, font));
        Token reserved = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(127, 0, 85)), null, 1, boldFont));
        Token comment = new Token((Object)new TextAttribute(this.sharedTextColors.getColor(new RGB(63, 127, 95)), null, 0, font));
        WordRule reservedWord = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c) || c == '.';
            }
        });
        reservedWord.addWord("if", (IToken)reserved);
        reservedWord.addWord("then", (IToken)reserved);
        reservedWord.addWord("else", (IToken)reserved);
        reservedWord.addWord("match", (IToken)reserved);
        reservedWord.addWord("with", (IToken)reserved);
        reservedWord.addWord("data", (IToken)reserved);
        reservedWord.addWord("type", (IToken)reserved);
        reservedWord.addWord("class", (IToken)reserved);
        IRule[] rules = new IRule[]{new PatternRule("\"", "\"", (IToken)string, '\\', true), new MultiLineRule("/*", "*/", (IToken)comment), new EndOfLineRule("//", (IToken)comment), reservedWord};
        scanner.setRules(rules);
        scanner.setDefaultReturnToken((IToken)defaultToken);
        return scanner;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new CSSEditorTextHover(sourceViewer, this.editorEnvironment);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableColoredLabels(true);
        assistant.setStatusLineVisible(true);
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)new CSSCompletionAssistProcessor(this.editorEnvironment), "__dftl_partition_content_type");
        assistant.setInformationControlCreator(CREATOR);
        assistant.setRestoreCompletionProposalSize(Activator.getDefault().getDialogSettings());
        return assistant;
    }
}

