package org.simantics.document.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.TabContribution;
import org.simantics.utils.ui.ExceptionUtils;

/**
 * Tool for configuring annotations for a resource before it is instantiated.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AnnotationConfigurator {

	private Resource type;
	private Resource lib;
	boolean useVG = false;
	Variable annotationHolderVariable;
	
	public AnnotationConfigurator(Resource type, Resource lib) {
		this.type = type;
		this.lib = lib;
		
	}
	
	public void createComposite(Composite parent) {
		annotationHolderVariable = createAnnotationHolder2();
		
//		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
//		IWorkbenchPartSite site = page.getActivePart().getSite();
		IWorkbenchPartSite site = null;
		
		Collection<ComparableTabContributor> contribution = getAnnotationTab(annotationHolderVariable);
		ISelection selection = new StructuredSelection(annotationHolderVariable);
		for (ComparableTabContributor c : contribution) {
			
			IPropertyTab tab = c.create(parent, site, Simantics.getSessionContext(), selection);
			tab.setInput(Simantics.getSessionContext(), selection, false);
		}
	}
	
	
//	private Resource createAnnotationHolder() {
//		VirtualGraph vg = null;
//		if (useVG) {
//			VirtualGraphSupport support = Simantics.getSession().getService(VirtualGraphSupport.class);
//			vg = support.getMemoryPersistent("document_annotation");
//		}
//		Resource annotationHolder = null;
//		try {
//			annotationHolder = Simantics.getSession().syncRequest(new WriteResultRequest<Resource>(vg) {
//				public Resource perform(WriteGraph graph) throws DatabaseException {
//					Layer0 l0 = Layer0.getInstance(graph);
//					Resource annotationHolderDoc = graph.newResource();
//					graph.claim(annotationHolderDoc, l0.InstanceOf, type);
//					graph.claimLiteral(annotationHolderDoc, l0.HasName, "Template");
//					graph.claim(lib, l0.ConsistsOf, annotationHolderDoc);
//					return annotationHolderDoc;
//				}
//			});
//	
//		} catch (DatabaseException e1) {
//			ExceptionUtils.logAndShowError(e1);
//		}
//		return annotationHolder;
//	}
	
	private Variable createAnnotationHolder2() {
		VirtualGraph vg = null;
		if (useVG) {
			VirtualGraphSupport support = Simantics.getSession().getService(VirtualGraphSupport.class);
			vg = support.getMemoryPersistent("document_annotation"); //$NON-NLS-1$
		}
		Variable annotationHolder = null;
		try {
			annotationHolder = Simantics.getSession().syncRequest(new WriteResultRequest<Variable>(vg) {
				public Variable perform(WriteGraph graph) throws DatabaseException {
					Layer0 l0 = Layer0.getInstance(graph);
					Resource annotationHolderDoc = graph.newResource();
					graph.claim(annotationHolderDoc, l0.InstanceOf, type);
					graph.claimLiteral(annotationHolderDoc, l0.HasName, "Template"); //$NON-NLS-1$
					graph.claim(lib, l0.ConsistsOf, annotationHolderDoc);
					if (graph.isInstanceOf(lib, type)) {
						copyAnnotations(graph, lib, annotationHolderDoc);
					}
					return graph.adapt(annotationHolderDoc, Variable.class);
				}
			});
	
		} catch (DatabaseException e1) {
			ExceptionUtils.logAndShowError(e1);
		}
		return annotationHolder;
	}
	
//	private Variable createAnnotationHolder3() {
//		Resource r = createAnnotationHolder();
//		return new StandardGraphChildVariable(null, null, r);
//	}
	
	private Collection<ComparableTabContributor> getAnnotationTab(final Object selection) {
		try {
			return Simantics.getSession().syncRequest(new Read<Collection<ComparableTabContributor>>() {
				@SuppressWarnings({ "rawtypes", "unchecked" })
				@Override
				public Collection<ComparableTabContributor> perform(ReadGraph graph)
						throws DatabaseException {
					AnnotationResource ann = AnnotationResource.getInstance(graph);
					TabContribution contribution = graph.adapt(ann.SelectionTabContribution, TabContribution.class);
					Collection<ComparableTabContributor> coll = new ArrayList<ComparableTabContributor>();
					contribution.contribute(graph, selection, coll);
					return coll;
				}
			});
		} catch (DatabaseException e) {
			ExceptionUtils.logAndShowError(e);
			return null;
		}
	}
	
	public void apply(final Resource to) throws DatabaseException{
		Simantics.getSession().syncRequest(new WriteRequest() {
			
			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				apply(graph, to);
			}
		});
		
	}
	
	public void apply(WriteGraph graph, Resource to) throws DatabaseException{
		Resource from = annotationHolderVariable.getPossibleRepresents(graph);
		copyAnnotations(graph, from, to);

	}
	
	private void copyAnnotations(WriteGraph graph, Resource from, Resource to) throws DatabaseException{
		Layer0 l0 = Layer0.getInstance(graph);
		AnnotationResource ann = AnnotationResource.getInstance(graph);
		
		List<Statement> annotations = new ArrayList<Statement>();
		for (Statement s : graph.getStatements(from, l0.HasProperty)) {
			if (graph.isInstanceOf(s.getObject(),ann.Annotation) ){
				annotations.add(s);
			}
		}
		
		for (Statement annotation : annotations) {
			Resource annotationInstance = graph.newResource();
			graph.claim(to, annotation.getPredicate(), annotationInstance);
			for (Resource type : graph.getObjects(annotation.getObject(), l0.InstanceOf)) {
				graph.claim(annotationInstance, l0.InstanceOf, type);
			}
			for (Statement property : graph.getStatements(annotation.getObject(), l0.HasProperty)) {
				if (property.isAsserted(annotation.getObject()))
					continue;
				graph.claimLiteral(annotationInstance, property.getPredicate(), graph.getValue(property.getObject()));
			}
		}
	}
	
	public void dispose() {
		
		if (useVG) {
			VirtualGraphSupport support = Simantics.getSession().getService(VirtualGraphSupport.class);
			VirtualGraph vg = support.getMemoryPersistent("document_annotation"); //$NON-NLS-1$
			support.discard(vg);
		} else {
			
			Simantics.getSession().asyncRequest(new WriteRequest() {
				
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					Resource r = annotationHolderVariable.getPossibleRepresents(graph);
					graph.deny(r);
					
				}
			});
			
		}
		
	}
}
