/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import java.io.File;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.ui.graphfile.FileDocumentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsynchronizeDocumentFolder implements ActionFactory {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(UnsynchronizeDocumentFolder.class);
	
	@Override
	public Runnable create(Object target) {

		if(!(target instanceof Resource))
			return null;

		final Resource resource = (Resource)target;

		return new Runnable() {
			@Override
			public void run() {

				try {
				
					File folder = FileDocumentUtil.possibleDocumentFolderPath(Simantics.getSession(), resource);
					if(folder != null) {
						FileDocumentUtil.removeDocumentFolderSynchronizer(Simantics.getSession(), resource);
					}
				
				} catch (Exception e) {
					LOGGER.error("Error while setting up document folder synchronization", e);
				}

			}
		};
	}
	
}
