/*******************************************************************************
 * Copyright (c) 2023, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.prefs;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * @author Tuukka Lehtonen
 */
public class DocumentsPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	private final ScopedPreferenceStore instanceStore      = DocumentsPreferences.getStore();

	public DocumentsPreferencePage() {
		super(GRID);
	}

	@Override
	public void init(IWorkbench workbench) {
	}

	@Override
	protected IPreferenceStore doGetPreferenceStore() {
		return instanceStore;
	}

	@Override
	protected void createFieldEditors() {
		BooleanFieldEditor f1 = new BooleanFieldEditor(DocumentsPreferences.P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS, "Prefer External Editor for opening embedded documents", getFieldEditorParent()); //$NON-NLS-1$
		addField(f1);
		BooleanFieldEditor f2 = new BooleanFieldEditor(DocumentsPreferences.P_DOCUMENTATION_VIEW_EDITOR_VISIBLE, "Show editing controls in Documentation view", getFieldEditorParent()); //$NON-NLS-1$
		addField(f2);
	}

}