package org.simantics.document.ui.actions;

import java.util.List;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.document.DocumentResource;
import org.simantics.utils.ui.ISelectionUtils;

public class FolderDropAction implements DropActionFactory {
	
	private Resource folderType;
	private Resource relation;
	private Resource inverse;
	
	public FolderDropAction(ReadGraph graph, String folderUri, String relationUri) throws DatabaseException {
		folderType = graph.getResource(folderUri);
		relation = graph.getResource(relationUri);
		inverse = graph.getPossibleInverse(relation);
	}
	
	@Override
	public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
		final Resource lib = ISelectionUtils.getSinglePossibleKey(target, SelectionHints.KEY_MAIN, Resource.class);

		if (lib == null)
			return null;

		final List<Resource> selections = ISelectionUtils.getPossibleKeys(source, SelectionHints.KEY_MAIN, Resource.class);

		if (selections.isEmpty()) {
			return null;
		}
		if (!g.isInstanceOf(lib, folderType))
			return null;
		DocumentResource doc = DocumentResource.getInstance(g);
		for (Resource r : selections) {
			if (!g.isInstanceOf(r, doc.Document))
				return null;
		}
		Runnable runnable = new Runnable() {

			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {

					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						
						for (Resource r : selections) {
							if (!graph.hasStatement(lib,relation,r)) {
								if (inverse != null) {
									// check if moved document is children of another document (tree revisions)
									// if it is, prevent moving it.
									Resource r2 = graph.getPossibleObject(r, inverse);
									if (r2 != null && !graph.isInstanceOf(r2, folderType))
										continue;
									graph.deny(r,inverse);
								}
								graph.claim(lib, relation,r);
							}
						}
					}
				});
			}
		};
		return runnable;
		
	}

}
