/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.graphfile.DocumentVersionUtils;
import org.simantics.document.ui.graphfile.FileDocumentUtil;

/**
 * Abstract base class for adding documents.
 * 
 * If import target is an document, a new version of a document is created.
 * 
 * Document version creation has two modes:
 * FLAT: new version is added to the same library as the old document.
 * TREE: new version replaces the old document in the library, and old document is moved under the new document.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public abstract class AddDocumentAction implements ActionFactory {
	

	
	
	private Resource relation;
	
	public AddDocumentAction(ReadGraph graph, String relationUri) throws DatabaseException {
		relation = graph.getResource(relationUri);
	}
	

	protected Resource getRelation() {
		return relation;
	}
	
	protected void linkDocument(WriteGraph graph, Resource target, Resource newDocument) throws DatabaseException{
		DocumentResource doc = DocumentResource.getInstance(graph);
	
		if (graph.isInstanceOf(target, doc.Document)) {
			// adding a new revision
			DocumentVersionUtils.createNewVersion(graph, target, newDocument, relation);
			
			
		} else {
			graph.claim(target, relation, newDocument);
			FileDocumentUtil.createUniqueName(graph, newDocument);
		}
	}

}
