package org.simantics.document.server.io;

public class SimpleFont implements IFont {

	private final String family;
	private final String style;
	private final int height;

	public SimpleFont(String family, String style, int height) {
		this.family = family;
		this.style = style;
		this.height = height;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((family == null) ? 0 : family.hashCode());
		result = prime * result + height;
		result = prime * result + ((style == null) ? 0 : style.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SimpleFont other = (SimpleFont) obj;
		if (family == null) {
			if (other.family != null)
				return false;
		} else if (!family.equals(other.family))
			return false;
		if (height != other.height)
			return false;
		if (style == null) {
			if (other.style != null)
				return false;
		} else if (!style.equals(other.style))
			return false;
		return true;
	}

	@Override
	public String getFamily() {
		return family;
	}

	@Override
	public String getStyle() {
		return style;
	}

	@Override
	public int getHeight() {
		return height;
	}
	
}
