package org.simantics.document.server.io;

import java.io.File;
import java.io.IOException;

public interface IResponse {
	void setStatus(int statusCode);
	void setContentType(String contentType);
	void setHeader(String name, String value);
	void setCookie(String name, String value, int maxAge, String path);
	void setCacheTime(long milliseconds);	
	void setContentLength(long length);
	void writeBytes(byte[] bytes) throws IOException;
	void writeString(String string) throws IOException;
	long writeFile(File file) throws IOException;
	void close() throws IOException;
}
