/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.io;

import java.util.Map;

public interface IConsole {

	String getConsoleGUID();
	String getSessionGUID();

	void addMessage(String message);
	void setEditMode(boolean value);
	void sendEvent(String id, String event, Object ... keyValues);
	void sendEvent(String id, String event, CommandContext context);

	Map<String, String> getParameterMap();

}
