/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;

public class TranslateElement
extends ModificationAdapter {
    Resource element;
    Point2D absolutePosition;
    Point2D offset;

    public static TranslateElement absolute(Resource element, double x, double y) {
        return new TranslateElement(element, (Point2D)new Point2D.Double(x, y), null);
    }

    public static TranslateElement absolute(Resource element, Point2D absolutePosition) {
        return new TranslateElement(element, absolutePosition, null);
    }

    public static TranslateElement offset(Resource element, double x, double y) {
        return new TranslateElement(element, null, (Point2D)new Point2D.Double(x, y));
    }

    public static TranslateElement offset(Resource element, Point2D offset) {
        return new TranslateElement(element, null, offset);
    }

    public TranslateElement(IElement element, Point2D absolutePosition, Point2D offset) {
        this((Resource)element.getHint(ElementHints.KEY_OBJECT), absolutePosition, offset);
    }

    public TranslateElement(Resource element, Point2D absolutePosition, Point2D offset) {
        super(LOW_PRIORITY);
        this.element = element;
        this.absolutePosition = absolutePosition;
        this.offset = offset;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        boolean changed;
        if (this.absolutePosition == null && this.offset == null) {
            return;
        }
        AffineTransform at = DiagramGraphUtil.getTransform((ReadGraph)graph, this.element);
        double x = at.getTranslateX();
        double y = at.getTranslateY();
        if (this.absolutePosition != null) {
            x = this.absolutePosition.getX();
            y = this.absolutePosition.getY();
        }
        if (this.offset != null) {
            x += this.offset.getX();
            y += this.offset.getY();
        }
        boolean bl = changed = x != at.getTranslateX() || y != at.getTranslateY();
        if (!changed) {
            return;
        }
        at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), x, y);
        DiagramGraphUtil.setTransform(graph, this.element, at);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Translated " + String.valueOf(this.element)));
    }
}

