/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingResources;

public class TransformElement
extends ModificationAdapter {
    Resource elementResource;
    AffineTransform tr;

    public TransformElement(Resource element, AffineTransform tr) {
        super(LOW_PRIORITY);
        this.elementResource = element;
        this.tr = tr;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        DiagramGraphUtil.setTransform(g, this.elementResource, this.tr);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource component = g.getPossibleObject(this.elementResource, MOD.ElementToComponent);
        if (component != null) {
            g.addMetadata((Metadata)cm.add("Transformed " + NameUtils.getSafeName((ReadGraph)g, (Resource)component)));
        } else {
            g.addMetadata((Metadata)cm.add("Transformed " + String.valueOf(this.elementResource)));
        }
    }
}

