/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class AddConnection
extends ModificationAdapter {
    IModifiableSynchronizationContext context;
    IDiagram diagram;
    Resource diagramResource;
    IElement element;
    Resource copyOf;
    Resource connectionClassResource;

    public AddConnection(IModifiableSynchronizationContext context, IDiagram diagram, IElement element) {
        super(ADD_CONNECTION_PRIORITY);
        this.context = context;
        this.diagram = diagram;
        this.diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        assert (this.diagramResource != null);
        this.element = element;
        this.copyOf = (Resource)element.getHint(ElementHints.KEY_COPY_OF_OBJECT);
        this.connectionClassResource = (Resource)ElementUtils.checkedAdapt((ElementClass)element.getElementClass(), Resource.class);
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        CopyAdvisor ca;
        ConnectionUtil cu = new ConnectionUtil(graph);
        DiagramMutator mutator = (DiagramMutator)this.diagram.getHint(DiagramHints.KEY_MUTATOR);
        Resource resource = null;
        if (this.copyOf != null && (ca = (CopyAdvisor)this.diagram.getHint(SynchronizationHints.COPY_ADVISOR)) != null) {
            Resource sourceDiagram = graph.getPossibleObject(this.copyOf, Layer0.getInstance((ReadGraph)graph).PartOf);
            if (sourceDiagram == null) {
                sourceDiagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)this.copyOf, (Resource)DiagramResource.getInstance((ReadGraph)graph).Diagram);
            }
            if ((resource = CopyAdvisorUtil.copy(this.context, graph, ca, this.copyOf, sourceDiagram, this.diagramResource)) != null) {
                OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)this.diagramResource, (Resource)resource);
            }
        }
        if (resource == null) {
            resource = cu.newConnection(this.diagramResource, this.connectionClassResource);
        }
        if (this.copyOf != null) {
            AddConnection.copyConnectionType(graph, this.copyOf, resource);
        }
        this.element.setHint(ElementHints.KEY_OBJECT, (Object)resource);
        mutator.register(this.element, (Object)resource);
        GraphLayerManager glm = (GraphLayerManager)this.context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        if (glm != null) {
            glm.removeFromAllLayers(graph, resource);
            glm.putElementOnVisibleLayers(this.diagram, graph, resource);
        }
    }

    public static void copyConnectionType(WriteGraph graph, Resource source, Resource target) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        Resource connectionType = graph.getPossibleObject(source, sr.HasConnectionType);
        if (connectionType != null) {
            graph.deny(target, sr.HasConnectionType);
            graph.claim(target, sr.HasConnectionType, null, connectionType);
        }
    }
}

