/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization;

import org.simantics.db.WriteGraph;
import org.simantics.diagram.synchronization.IModification;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ThreadingModificationProxy
extends ModificationAdapter {
    private final IModification m;
    private final IThreadWorkQueue completionThread;
    private final boolean syncCompletion;

    public ThreadingModificationProxy(IModification m, IThreadWorkQueue completionThread, boolean syncCompletion) {
        super(m.getPriority());
        this.m = m;
        this.completionThread = completionThread;
        this.syncCompletion = syncCompletion;
    }

    @Override
    public void completed() {
        if (this.completionThread != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ThreadingModificationProxy.this.m.completed();
                }
            };
            if (this.syncCompletion) {
                ThreadUtils.syncExec((IThreadWorkQueue)this.completionThread, (Runnable)r);
            } else {
                ThreadUtils.asyncExec((IThreadWorkQueue)this.completionThread, (Runnable)r);
            }
        } else {
            this.m.completed();
        }
    }

    @Override
    public boolean isComplete() {
        return this.m.isComplete();
    }

    @Override
    public void markComplete() {
        this.m.markComplete();
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        this.m.perform(g);
    }

    @Override
    public Throwable getException() {
        return this.m.getException();
    }

    @Override
    public void setException(Throwable t) {
        this.m.setException(t);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.m) + "]";
    }
}

