/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import java.nio.CharBuffer;

class DefaultFilterStrategy {
    private static final boolean DEBUG = false;

    DefaultFilterStrategy() {
    }

    private static StringBuilder addSearchWord(StringBuilder sb, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append('|');
        }
        sb.append('(');
        sb.append(pattern);
        sb.append(')');
        return sb;
    }

    private static String toString(CharBuffer cb) {
        cb.limit(cb.position());
        cb.reset();
        String result = cb.toString();
        cb.limit(cb.capacity());
        return result;
    }

    public static String toSinglePatternString(String filter, boolean implicitPreAsterisk) {
        if (!filter.isEmpty()) {
            filter = filter.toLowerCase();
            Object regExFilter = filter.replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("^", "\\^").replace("$", "\\$").replace("|", ".*|").replace("&&", "\\&&");
            if (implicitPreAsterisk && !((String)regExFilter).startsWith(".*")) {
                regExFilter = ".*" + (String)regExFilter;
            }
            if (!((String)regExFilter).endsWith(".*")) {
                regExFilter = (String)regExFilter + ".*";
            }
            return regExFilter;
        }
        return null;
    }

    public static String defaultToPatternString(String filter, boolean implicitPreAsterisk) {
        if (filter.isEmpty()) {
            return null;
        }
        CharBuffer buf = CharBuffer.allocate(filter.length() * 2);
        buf.mark();
        StringBuilder sb = new StringBuilder(filter.length() * 2);
        boolean inQuote = false;
        int len = filter.length();
        int i = 0;
        while (i < len) {
            char ch = filter.charAt(i);
            if (ch == '\"') {
                if (!inQuote) {
                    inQuote = true;
                } else {
                    inQuote = false;
                    DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
                }
                ++i;
                continue;
            }
            if (ch == '\\') {
                if (++i >= len) break;
                ch = filter.charAt(i);
                buf.append(ch);
                ++i;
                break;
            }
            if (ch == ' ') {
                if (inQuote) {
                    buf.append(ch);
                    ++i;
                    continue;
                }
                if (buf.position() > 0) {
                    DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
                }
                ++i;
                continue;
            }
            buf.append(ch);
            ++i;
        }
        if (buf.position() > 0) {
            DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
        }
        return sb.toString();
    }
}

