/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.SymbolContributionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolProviderFactories {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymbolProviderFactories.class);

    private static boolean testFilter(ReadGraph graph, Resource contribution, Resource filterR, Resource diagram) throws DatabaseException {
        boolean trace;
        block7: {
            trace = LOGGER.isTraceEnabled();
            try {
                if (trace) {
                    LOGGER.trace("testFilter({}, {}, {})", new Object[]{NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)contribution), NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)filterR), NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)diagram)});
                }
                SymbolContributionFilter filter = (SymbolContributionFilter)graph.syncRequest((Read)new PossibleAdapter(filterR, SymbolContributionFilter.class), (AsyncProcedure)TransientCacheAsyncListener.instance());
                if (trace) {
                    LOGGER.trace("\tfilter: {}", (Object)filter);
                }
                if (filter != null && filter.accept(graph, contribution, filterR, diagram)) break block7;
                if (trace) {
                    LOGGER.trace("\t\treject");
                }
                return false;
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.diagram", "Filter " + String.valueOf(filterR) + " testing failed", (Throwable)e));
                return false;
            }
        }
        if (trace) {
            LOGGER.trace("\t\taccept");
        }
        return true;
    }

    public static boolean accept(ReadGraph graph, DiagramResource DIA, Resource contribution, Resource diagram) throws DatabaseException {
        String name = (String)graph.getPossibleAdapter(contribution, String.class);
        if (name == null) {
            return false;
        }
        for (Resource filterR : graph.getObjects(contribution, DIA.HasSymbolContributionFilter)) {
            if (SymbolProviderFactories.testFilter(graph, contribution, filterR, diagram)) continue;
            return false;
        }
        return true;
    }
}

