/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.BasicSymbolProviderFactory;
import org.simantics.diagram.symbolcontribution.Hasher;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.layer0.Layer0;

public class IndexRootSymbolProviderFactory
implements SymbolProviderFactory {
    private final Resource indexRoot;
    private final Resource diagram;
    private byte[] contributionHash;
    private transient int hash;

    public IndexRootSymbolProviderFactory(ReadGraph graph, Resource indexRoot, Resource diagram) throws DatabaseException {
        this.indexRoot = indexRoot;
        this.diagram = diagram;
        this.contributionHash = (byte[])graph.syncRequest((Read)new LoadHashRequest(indexRoot, diagram));
    }

    private int hash() {
        int result = 1;
        result = 31 * result + (this.indexRoot == null ? 0 : this.indexRoot.hashCode());
        result = 31 * result + Arrays.hashCode(this.contributionHash);
        return result;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hash();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRootSymbolProviderFactory other = (IndexRootSymbolProviderFactory)obj;
        return Objects.equals(this.indexRoot, other.indexRoot) && Arrays.equals(this.contributionHash, other.contributionHash);
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.indexRoot, this.diagram));
    }

    static class LoadHashRequest
    extends BinaryRead<Resource, Resource, byte[]> {
        public LoadHashRequest(Resource indexRoot, Resource diagram) {
            super((Object)indexRoot, (Object)diagram);
        }

        public byte[] perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Hasher h = new Hasher();
            if (this.parameter != null) {
                h.update((Resource)this.parameter);
                Instances query = (Instances)graph.adapt(DIA.SymbolReferenceLibrary, Instances.class);
                for (Resource library : cs.asSortedList(query.find(graph, (Resource)this.parameter))) {
                    BasicSymbolProviderFactory.hashGroup(graph, h, library, L0.IsRelatedTo, (Resource)this.parameter2);
                }
            }
            return h.digest();
        }
    }

    static class LoadRequest
    extends BinaryRead<Resource, Resource, ISymbolProvider> {
        public LoadRequest(Resource indexRoot, Resource diagram) {
            super((Object)indexRoot, (Object)diagram);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = (Layer0)graph.l0();
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>();
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            if (this.parameter != null) {
                Instances query = (Instances)graph.adapt(DIA.SymbolReferenceLibrary, Instances.class);
                for (Resource library : cs.asSortedList(query.find(graph, (Resource)this.parameter))) {
                    if (!SymbolProviderFactories.accept(graph, DIA, library, (Resource)this.parameter2)) continue;
                    groups.add(BasicSymbolProviderFactory.createGroup(graph, library, L0.IsRelatedTo, (Resource)this.parameter2));
                }
            }
            return new SymbolProvider(groups);
        }
    }
}

