/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import org.eclipse.core.runtime.IAdaptable;

final class AdaptableTriple<T1, T2, T3>
implements IAdaptable {
    public final T1 first;
    public final T2 second;
    public final T3 third;
    private final int hash;

    public static <T1, T2, T3> AdaptableTriple<T1, T2, T3> make(T1 t1, T2 t2, T3 t3) {
        return new AdaptableTriple<T1, T2, T3>(t1, t2, t3);
    }

    public AdaptableTriple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AdaptableTriple other = (AdaptableTriple)obj;
        if (!(other.first == this.first || other.first != null && other.first.equals(this.first))) {
            return false;
        }
        if (!(other.second == this.second || other.second != null && other.second.equals(this.second))) {
            return false;
        }
        return other.third == this.third || other.third != null && other.third.equals(this.third);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ", " + String.valueOf(this.third) + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode()) * 31 + (this.third == null ? 0 : this.third.hashCode()) * 31 * 31;
    }

    private Object adapt(Object o, Class<?> clazz) {
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof IAdaptable) {
            return ((IAdaptable)o).getAdapter(clazz);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Object o = this.adapt(this.first, adapter);
        if (o == null) {
            o = this.adapt(this.second, adapter);
        }
        if (o == null) {
            o = this.adapt(this.third, adapter);
        }
        return o;
    }
}

