/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ContextUtil
extends AbstractCanvasParticipant {
    private static final boolean DEBUG = false;
    private final IContextService service;
    private final IThreadWorkQueue thread;
    private final Map<String, IContextActivation> activations = new ConcurrentHashMap<String, IContextActivation>();

    public ContextUtil(IContextService service, IThreadWorkQueue contextManipulationThread) {
        assert (service != null);
        assert (contextManipulationThread != null);
        this.service = service;
        this.thread = contextManipulationThread;
    }

    public void inContextThread(Runnable r) {
        this.exec(r, true);
    }

    private void debug(String s) {
        this.debug(false, s);
    }

    private void debug(boolean trace, String s) {
    }

    private void checkThread() {
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in context thread, use ContextUtil.inContextThread(Runnable)");
        }
    }

    private void exec(Runnable r) {
        this.exec(r, false);
    }

    private void exec(Runnable r, boolean allowSchedule) {
        if (!allowSchedule) {
            this.checkThread();
        }
        if (this.thread.getThread() == null) {
            return;
        }
        if (this.thread.currentThreadAccess()) {
            r.run();
        } else {
            ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)r);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.exec(new Runnable(){

            @Override
            public void run() {
                ContextUtil.this.deactivateAll();
            }
        }, true);
        super.removedFromContext(ctx);
    }

    private void doActivate(String contextId) {
        IContextActivation activation;
        if (!this.activations.containsKey(contextId) && (activation = this.service.activateContext(contextId)) != null) {
            this.activations.put(contextId, activation);
        }
    }

    public void activate(final String contextId) {
        this.checkThread();
        assert (contextId != null);
        this.exec(new Runnable(){

            @Override
            public void run() {
                ContextUtil.this.doActivate(contextId);
            }
        });
    }

    public void activate(final Collection<String> contextIds) {
        if (contextIds.isEmpty()) {
            return;
        }
        this.exec(new Runnable(){

            @Override
            public void run() {
                for (String id : contextIds) {
                    ContextUtil.this.doActivate(id);
                }
            }
        });
    }

    public void deactivate(Collection<String> contextIds) {
        this.checkThread();
        assert (contextIds != null);
        for (String id : contextIds) {
            final IContextActivation a = this.activations.remove(id);
            if (a == null) continue;
            this.exec(new Runnable(){

                @Override
                public void run() {
                    ContextUtil.this.service.deactivateContext(a);
                }
            });
        }
    }

    public void deactivate(IContextActivation activation) {
        this.checkThread();
        assert (activation != null);
        final IContextActivation a = this.activations.remove(activation.getContextId());
        if (a == activation) {
            this.exec(new Runnable(){

                @Override
                public void run() {
                    ContextUtil.this.service.deactivateContext(a);
                }
            });
        }
    }

    public void deactivateAll() {
        this.checkThread();
        final Collection<IContextActivation> acts = this.getActivations();
        this.activations.clear();
        this.exec(new Runnable(){

            @Override
            public void run() {
                for (IContextActivation a : acts) {
                    ContextUtil.this.service.deactivateContext(a);
                }
            }
        });
    }

    public synchronized Collection<IContextActivation> getActivations() {
        return Collections.unmodifiableCollection(new ArrayList<IContextActivation>(this.activations.values()));
    }

    public synchronized Collection<String> getActivatedContextIds() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.activations.keySet()));
    }
}

