/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.simantics.diagram.handler.DiagramSelection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.SelectionOutline;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class HighlightMode
extends AbstractCanvasParticipant
implements IHintListener {
    private final Color CUT_COLOR = Color.ORANGE;
    private final Color COPY_COLOR = new Color(128, 220, 150);
    private final BasicStroke DEFAULT_STROKE = new BasicStroke(3.0f);
    DiagramSelection selection;
    int selectionId;
    int paintPriority;
    SingleElementNode highlightNode;
    Collection<IElement> highlightElements;
    Future<?> updateTask;
    Runnable updateScheduler = new Runnable(){

        @Override
        public void run() {
            ICanvasContext ctx = HighlightMode.this.getContext();
            if (ctx != null) {
                ThreadUtils.asyncExec((IThreadWorkQueue)ctx.getThreadAccess(), (Runnable)HighlightMode.this.painter);
            }
        }
    };
    Runnable painter = new Runnable(){

        @Override
        public void run() {
            if (!HighlightMode.this.isRemoved() && HighlightMode.this.highlightNode.getRootNode() != null) {
                HighlightMode.this.paintSelectionFrames((G2DParentNode)HighlightMode.this.highlightNode, HighlightMode.this.selection, HighlightMode.this.selectionId);
            }
            HighlightMode.this.updateTask = null;
        }
    };

    public HighlightMode(DiagramSelection selection, int selectionId, int paintPriority) {
        this.selection = selection;
        this.selectionId = selectionId;
        this.paintPriority = paintPriority;
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CANVAS)
    public void init(G2DParentNode parent) {
        this.highlightNode = (SingleElementNode)parent.addNode("cut/copy source highlight", SingleElementNode.class);
        this.highlightNode.setZIndex(this.paintPriority);
        this.highlightNode.setVisible(Boolean.valueOf(false));
        this.highlightElements = this.selection.getOriginalElements();
        for (IElement e : this.highlightElements) {
            e.addHintListener((IHintListener)this);
        }
        this.paintSelectionFrames((G2DParentNode)this.highlightNode, this.selection, this.selectionId);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        for (IElement e : this.highlightElements) {
            e.removeHintListener((IHintListener)this);
        }
        this.highlightNode.remove();
    }

    void paintSelectionFrames(G2DParentNode parentNode, DiagramSelection selection, int selectionId) {
        Area cutArea = new Area();
        for (IElement e : selection.getOriginalElements()) {
            ElementClass ec = e.getElementClass();
            SelectionOutline so = (SelectionOutline)ec.getAtMostOneItemOfClass(SelectionOutline.class);
            Shape shape = so != null ? so.getSelectionShape(e) : ElementUtils.getElementShapeOrBoundsOnDiagram((IElement)e);
            cutArea.add(new Area(shape));
        }
        if (!cutArea.isEmpty()) {
            Path2D.Double path = new Path2D.Double(cutArea);
            ShapeNode shapeNode = (ShapeNode)parentNode.getOrCreateNode("highlight", ShapeNode.class);
            shapeNode.setShape((Shape)path);
            shapeNode.setScaleStroke(true);
            shapeNode.setStroke((Stroke)this.DEFAULT_STROKE);
            shapeNode.setFill(false);
            shapeNode.setColor((Paint)(selection.isCut() ? this.CUT_COLOR : this.COPY_COLOR));
            this.highlightNode.setVisible(Boolean.valueOf(true));
        }
    }

    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (key == ElementHints.KEY_TRANSFORM) {
            this.highlightNode.setVisible(Boolean.valueOf(false));
            this.deferredHighlightUpdate();
        }
    }

    public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
    }

    private synchronized void deferredHighlightUpdate() {
        if (this.updateTask == null) {
            this.updateTask = ThreadUtils.getNonBlockingWorkExecutor().schedule(this.updateScheduler, 100L, TimeUnit.MILLISECONDS);
        }
    }
}

