/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.commandlog.CopyOrCutElementsCommand;
import org.simantics.diagram.commandlog.PasteElementsCommand;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.DiagramContentTracker;
import org.simantics.diagram.handler.CopyOperation;
import org.simantics.diagram.handler.CopyPasteStrategy;
import org.simantics.diagram.handler.CopyPasteUtil;
import org.simantics.diagram.handler.CopyStrategy;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.diagram.handler.DiagramSelection;
import org.simantics.diagram.handler.DiagramSelectionRepresentation;
import org.simantics.diagram.handler.ElementAssortment;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.diagram.handler.ElementType;
import org.simantics.diagram.handler.HighlightMode;
import org.simantics.diagram.handler.PasteException;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.LocalDelegateNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.snap.GridSnapAdvisor;
import org.simantics.scenegraph.utils.NodeMapper;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPasteHandler
extends AbstractDiagramParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyPasteHandler.class);
    public static final IHintContext.Key KEY_CUT_SELECTION_FRAME_COLOR = new IHintContext.KeyOf(Color.class, "CUT_SELECTION_FRAME_COLOR");
    public static final IHintContext.Key KEY_CUT_SELECTION_CONTENT_COLOR = new IHintContext.KeyOf(Color.class, "CUT_SELECTION_CONTENT_COLOR");
    public static final IHintContext.Key KEY_COPIED_SELECTION_FRAME_COLOR = new IHintContext.KeyOf(Color.class, "COPY_SELECTION_FRAME_COLOR");
    public static final IHintContext.Key KEY_COPIED_SELECTION_CONTENT_COLOR = new IHintContext.KeyOf(Color.class, "COPY_SELECTION_CONTENT_COLOR");
    private static final IHintContext.Key KEY_DIAGRAM_SELECTION = DiagramSelectionRepresentation.KEY_DIAGRAM_SELECTION;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SELECTION_UPDATE = false;
    public static final int COPY_GHOSTING_PAINT_PRIORITY = 600;
    protected static final int HIGHLIGHT_PAINT_PRIORITY = 500;
    @DependencyReflection.Dependency
    protected Selection sel;
    @DependencyReflection.Dependency
    protected MouseUtil mouseUtil;
    protected final IStatusLineManager statusLine;
    protected final CopyPasteStrategy strategy;
    protected IWorkbenchPartSite site;
    protected IWorkbenchPartSite listenedSite;
    IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == CopyPasteHandler.this.site.getPart()) {
                CopyPasteHandler.this.hasFocus = false;
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (CopyPasteHandler.this.listenedSite != null) {
                CopyPasteHandler.this.listenedSite.getPage().removePartListener(CopyPasteHandler.this.partListener);
                CopyPasteHandler.this.listenedSite = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == CopyPasteHandler.this.site.getPart()) {
                CopyPasteHandler.this.hasFocus = true;
            }
        }
    };
    protected boolean hasFocus = false;
    protected AbstractCanvasParticipant highlightMode = null;
    private IProject observedProject = null;
    private int pasteWithoutMovingGhostCounter = 0;
    private final Point2D pasteOffset = new Point2D.Double(0.0, 0.0);
    private MouseUtil.MouseInfo mouseInfo;
    private double monitorScale = 0.2;
    private DiagramSelectionUpdater selectionUpdater = null;
    IHintListener projectDiagramSelectionListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext ctx = CopyPasteHandler.this.getContext();
            if (ctx != null && CopyPasteHandler.this.hasHighlight() && (newValue == null || ((DiagramSelection)newValue).getSourceCanvas() != ctx)) {
                ctx.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CopyPasteHandler.this.removeHighlight();
                    }
                });
            }
        }
    };
    protected SingleElementNode ghostNode = null;
    protected NodeMapper ghostNodeMapper = new NodeMapper();

    public CopyPasteHandler() {
        this(new DefaultCopyPasteStrategy());
    }

    public CopyPasteHandler(CopyPasteStrategy strategy) {
        this(strategy, null);
    }

    public CopyPasteHandler(IStatusLineManager statusLine) {
        this(new DefaultCopyPasteStrategy(), statusLine);
    }

    public CopyPasteHandler(CopyPasteStrategy strategy, IStatusLineManager statusLine) {
        this.strategy = strategy != null ? strategy : new DefaultCopyPasteStrategy();
        this.statusLine = statusLine;
    }

    public CopyPasteHandler(CopyPasteStrategy strategy, IStatusLineManager statusLine, double monitorScale) {
        this.strategy = strategy != null ? strategy : new DefaultCopyPasteStrategy();
        this.statusLine = statusLine;
        this.setMonitorScale(monitorScale);
    }

    public CopyPasteHandler setMonitorScale(double scale) {
        this.monitorScale = scale;
        return this;
    }

    public CopyPasteHandler setWorkbenchSite(IWorkbenchPartSite site) {
        this.site = site;
        return this;
    }

    protected boolean isPasteAllowed() {
        return this.listenedSite == null || this.hasFocus;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.addProjectListener(this.peekProject());
        this.listenedSite = this.site;
        if (this.listenedSite != null) {
            this.listenedSite.getPage().addPartListener(this.partListener);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        DiagramSelection ds = this.getProjectSelection();
        if (ds.getSourceCanvas() == ctx) {
            this.removeProjectSelection();
        }
        if (this.listenedSite != null) {
            this.listenedSite.getPage().removePartListener(this.partListener);
            this.listenedSite = null;
        }
        this.removeProjectListener();
        super.removedFromContext(ctx);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (oldDiagram != null && this.selectionUpdater != null) {
            this.selectionUpdater.untrack();
            this.selectionUpdater = null;
        }
        if (newDiagram != null) {
            this.selectionUpdater = new DiagramSelectionUpdater(this.getContext(), newDiagram).track();
        }
    }

    private void addProjectListener(IProject observable) {
        if (observable != null) {
            observable.addKeyHintListener(KEY_DIAGRAM_SELECTION, this.projectDiagramSelectionListener);
            this.observedProject = observable;
        }
    }

    private void removeProjectListener() {
        if (this.observedProject != null) {
            this.observedProject.removeKeyHintListener(KEY_DIAGRAM_SELECTION, this.projectDiagramSelectionListener);
            this.observedProject = null;
        }
    }

    IProject getProject() {
        return Simantics.getProject();
    }

    IProject peekProject() {
        return Simantics.peekProject();
    }

    public DiagramSelection getClipboardDiagramSelection() {
        for (Set content : Simantics.getClipboard().getContents()) {
            try {
                DiagramSelection sel = (DiagramSelection)ClipboardUtils.accept((Set)content, (IHintContext.Key)DiagramSelectionRepresentation.KEY_DIAGRAM_SELECTION);
                if (sel == null) continue;
                return sel;
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.diagram", "Failed to retrieve clipboard content.", (Throwable)e));
            }
        }
        return DiagramSelection.EMPTY;
    }

    protected DiagramSelection getProjectSelection() {
        IProject p = this.peekProject();
        if (p == null) {
            return DiagramSelection.EMPTY;
        }
        DiagramSelection ds = (DiagramSelection)p.getHint(KEY_DIAGRAM_SELECTION);
        return ds != null ? ds : DiagramSelection.EMPTY;
    }

    protected void setDiagramSelection(DiagramSelection selection) {
        this.setProjectSelection(selection);
        this.strategy.copyToClipboard(selection);
    }

    protected void setProjectSelection(DiagramSelection selection) {
        assert (selection != null);
        IProject p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("no active project for selection");
        }
        this.clearSG();
        this.pasteWithoutMovingGhostCounter = 0;
        this.pasteOffset.setLocation(0.0, 0.0);
        p.setHint(KEY_DIAGRAM_SELECTION, (Object)selection);
    }

    protected void removeProjectSelection() {
        this.setProjectSelection(DiagramSelection.EMPTY);
        this.removeHighlight();
        this.clearSG();
        this.setDirty();
    }

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleDelete(CommandEvent e) {
        if (e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.DELETE) && this.highlightMode != null) {
            this.message(null);
            this.removeProjectSelection();
            return false;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKey(KeyEvent e) {
        DiagramSelection ds;
        if (e.keyCode == 17 && !(ds = this.getProjectSelection()).isEmpty()) {
            if (e instanceof KeyEvent.KeyPressedEvent) {
                if (ds.isCut()) {
                    this.message("Move selection");
                } else {
                    this.message("Paste selection");
                }
                this.updateSG(ds);
            } else if (e instanceof KeyEvent.KeyReleasedEvent) {
                this.selectedMessage(ds);
                this.hideSG(ds);
            }
            this.setDirty();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent e) {
        if (e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.CANCEL)) {
            DiagramSelection s = this.getProjectSelection();
            if (this.highlightMode != null || !s.isEmpty()) {
                this.message(null);
                this.removeProjectSelection();
                return true;
            }
            return false;
        }
        if (e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.CUT) || e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.COPY)) {
            boolean ret = this.initiateCopy(e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.CUT));
            if (ret) {
                if (Commands.isRecording()) {
                    ArrayList<Resource> elements = new ArrayList<Resource>();
                    DataElementMap map = (DataElementMap)this.diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
                    for (IElement element : this.getProjectSelection().getOriginalElements()) {
                        Object o;
                        if (map == null || !((o = map.getData(this.diagram, element)) instanceof Resource)) continue;
                        elements.add((Resource)o);
                    }
                    Commands.record((org.simantics.utils.commandlog.Command)new CopyOrCutElementsCommand(elements, e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.CUT)));
                }
            } else {
                this.removeProjectSelection();
            }
            return ret;
        }
        if (this.isPasteAllowed() && e.command.equals((Object)org.simantics.scenegraph.g2d.events.command.Commands.PASTE)) {
            boolean success = this.initiatePaste(e.command);
            if (success && Commands.isRecording()) {
                Resource target = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
                DiagramSelection ds = this.getClipboardDiagramSelection();
                Point2D pastePos = this.getPastePos(ds, false);
                GridSnapAdvisor snapAdvisor = (GridSnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
                if (snapAdvisor != null) {
                    snapAdvisor.snap(pastePos);
                }
                Commands.record((org.simantics.utils.commandlog.Command)new PasteElementsCommand(target, pastePos.getX(), pastePos.getY()));
            }
            return success;
        }
        return false;
    }

    public boolean initiatePaste(Command command) {
        DiagramSelection ds = this.getClipboardDiagramSelection();
        if (ds.isEmpty()) {
            return this.tryPasteMonitors();
        }
        return this.paste(command, ds);
    }

    public boolean initiateCopy(boolean cut) {
        IStatus status;
        int selectionId = 0;
        Set ss = this.sel.getSelection(selectionId);
        Point2D copyPos = this.getCopyStartPos(ss);
        if (ss.isEmpty() || copyPos == null) {
            this.message("Nothing to " + (cut ? "cut" : "copy"));
            return false;
        }
        ElementAssortment ea = new ElementAssortment(ss);
        String error = this.fixAssortment(ea, cut);
        if (error != null) {
            this.message(error);
            return false;
        }
        this.pruneAssortment(ea, cut);
        if (ea.isEmpty()) {
            this.message("Nothing to " + (cut ? "cut" : "copy"));
            return false;
        }
        if (this.strategy instanceof CopyStrategy && !(status = ((CopyStrategy)((Object)this.strategy)).copy(new CopyOperation(this.getContext(), ea, cut))).isOK()) {
            switch (status.getSeverity()) {
                case 2: 
                case 8: {
                    this.message(status.getMessage());
                    break;
                }
                case 4: {
                    this.error(status.getMessage());
                }
            }
            return false;
        }
        if (!cut && ea.containsAny(CopyPasteUtil.CONNECTION_PARTS)) {
            this.error("Cannot copy connection segments nor branch points.");
            return false;
        }
        if (ea.contains(CopyPasteUtil.FLAGS) && !cut && CopyPasteUtil.isFlagsOnlySelection(ea) && !CopyPasteUtil.checkFlagsCorrespondences(ea.flags, false)) {
            this.error("Cannot copy flag that already has a correspondence.");
            return false;
        }
        Resource sourceDiagram = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        DiagramSelection ds = new DiagramSelection(this.getContext(), sourceDiagram, ea.getAll(), cut, copyPos);
        this.setDiagramSelection(ds);
        this.removeHighlight();
        this.highlightMode = new HighlightMode(ds, selectionId, 500);
        this.getContext().add((Object)this.highlightMode);
        this.selectedMessage(ds);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean paste(Command command, DiagramSelection ds) {
        if (ds.isEmpty()) {
            this.message(null);
            return false;
        }
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"paste");
        ElementObjectAssortment ea = ds.getAssortment();
        try {
            if (CopyPasteUtil.isFlagsOnlySelection(ea)) {
                if (ds.isCut()) {
                    this.normalPaste(command, ds, ea, true);
                    this.removeHighlight();
                    this.setDiagramSelection(DiagramSelection.EMPTY);
                    this.resetSourceSelection(ds);
                } else {
                    if (!CopyPasteUtil.onlyFlagsWithoutCorrespondence((RequestProcessor)Simantics.getSession(), ea)) {
                        return true;
                    }
                    this.normalPaste(command, ds, ea, false);
                    this.removeHighlight();
                    this.setDiagramSelection(DiagramSelection.EMPTY);
                }
            } else if (ds.isCut()) {
                this.normalPaste(command, ds, ea, true);
                this.removeHighlight();
                this.setDiagramSelection(DiagramSelection.EMPTY);
                this.resetSourceSelection(ds);
            } else {
                this.normalPaste(command, ds, ea, false);
            }
            this.message(null);
        }
        catch (PasteException e) {
            this.error(e.getLocalizedMessage());
            ErrorLogger.defaultLog((IStatus)new Status(1, "org.simantics.diagram", "Problem in diagram paste operation, see exception for details.", (Throwable)e));
        }
        catch (DatabaseException e) {
            this.error(e.getLocalizedMessage());
            ErrorLogger.defaultLog((IStatus)new Status(1, "org.simantics.diagram", "Problem in diagram paste operation, see exception for details.", (Throwable)e));
        }
        this.clearSG();
        this.setDirty();
        return true;
    }

    void resetSourceSelection(DiagramSelection ds) {
        boolean sameDiagram;
        ICanvasContext cc = ds.getSourceCanvas();
        boolean bl = sameDiagram = this.diagram == ds.getSourceDiagram();
        if (!sameDiagram && cc != null && !cc.isDisposed()) {
            for (Selection sourceSelection : cc.getItemsByClass(Selection.class)) {
                Set empty = Collections.emptySet();
                sourceSelection.setSelection(0, empty);
            }
        }
    }

    private void normalPaste(Command command, DiagramSelection ds, ElementObjectAssortment ea, boolean cut) throws PasteException {
        Point2D copyPos = ds.getCopyPos();
        Point2D pastePos = this.getPastePos(ds, true);
        double dx = pastePos.getX() - copyPos.getX();
        double dy = pastePos.getY() - copyPos.getY();
        Point2D.Double pasteOffset = new Point2D.Double(dx, dy);
        try {
            Resource diagramResource = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            DiagramContentTracker tracker = diagramResource == null ? null : DiagramContentTracker.start(this.getContext(), (RequestProcessor)Simantics.getSession(), diagramResource);
            this.strategy.paste(new PasteOperation(command, this.getContext(), ds.getSourceDiagram(), diagramResource, this.diagram, ea, cut, pasteOffset));
            if (tracker != null) {
                DiagramContentChanges changes = tracker.update();
                this.selectionUpdater.setNewSelection(0, changes.pick(changes.elements, Change.ADDED));
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected String fixAssortment(ElementAssortment ea, boolean cut) {
        ConnectionEntity ce;
        Topology diagramTopology = (Topology)this.diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
        ArrayList conns = new ArrayList();
        for (IElement edge : ea.edges) {
            Object ec;
            Topology.Connection bc = diagramTopology.getConnection(edge, EdgeVisuals.EdgeEnd.Begin);
            if (bc != null && bc.node != null && bc.node.getElementClass().getAtMostOneItemOfClass(FlagHandler.class) != null) {
                ea.add(ElementType.Flag, bc.node);
            }
            if ((ec = diagramTopology.getConnection(edge, EdgeVisuals.EdgeEnd.End)) == null || ((Topology.Connection)ec).node == null || ((Topology.Connection)ec).node.getElementClass().getAtMostOneItemOfClass(FlagHandler.class) == null) continue;
            ea.add(ElementType.Flag, ((Topology.Connection)ec).node);
        }
        if (!CopyPasteUtil.isFlagsOnlySelection(ea)) {
            for (IElement flag : ea.flags) {
                conns.clear();
                diagramTopology.getConnections(flag, ElementUtils.getSingleTerminal((IElement)flag), conns);
                for (Topology.Connection conn : conns) {
                    IElement edge = conn.edge;
                    ConnectionEntity ce2 = (ConnectionEntity)edge.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    ea.add(ElementType.Connection, ce2.getConnection());
                }
            }
        }
        ArrayList<IElement> connectionsToRemove = new ArrayList<IElement>(ea.connections.size());
        for (IElement connection : ea.connections) {
            ConnectionHandler ch = (ConnectionHandler)connection.getElementClass().getSingleItem(ConnectionHandler.class);
            Collection connectors = ch.getTerminalConnections(connection, null);
            boolean allConnectorsSelected = true;
            for (Topology.Connection c : connectors) {
                if (ea.nodes.contains(c.node) || ea.flags.contains(c.node) || ea.references.contains(c.node)) continue;
                allConnectorsSelected = false;
                break;
            }
            if (allConnectorsSelected) continue;
            connectionsToRemove.add(connection);
        }
        ea.removeAll(ElementType.Connection, connectionsToRemove);
        ArrayList<IElement> flagsToRemove = new ArrayList<IElement>(ea.flags.size());
        for (IElement flag : ea.flags) {
            if (!CopyPasteUtil.flagIsExternal(flag)) continue;
            conns.clear();
            diagramTopology.getConnections(flag, ElementUtils.getSingleTerminal((IElement)flag), conns);
            for (Topology.Connection conn : conns) {
                IElement edge = conn.edge;
                ce = (ConnectionEntity)edge.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                IElement connection = ce.getConnection();
                if (ea.connections.contains(connection)) continue;
                flagsToRemove.add(flag);
            }
        }
        ea.removeAll(ElementType.Flag, flagsToRemove);
        if (cut) {
            ArrayList<Topology.Connection> connections = new ArrayList<Topology.Connection>();
            for (IElement node : CollectionUtils.join(ea.nodes, ea.flags)) {
                connections.clear();
                for (Topology.Connection connection : this.getAllConnections(node, connections)) {
                    ce = (ConnectionEntity)connection.edge.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    IElement conn = ce.getConnection();
                    if (ea.connections.contains(conn)) continue;
                    return "Cannot cut a node without all its connections.";
                }
            }
        }
        if (!cut) {
            ArrayList<IElement> referenceElementsToRemove = new ArrayList<IElement>();
            for (IElement ref : ea.references) {
                IElement parent = (IElement)ref.getHint(ElementHints.KEY_PARENT_ELEMENT);
                if (parent == null || ea.all.contains(parent)) continue;
                referenceElementsToRemove.add(ref);
            }
            if (!referenceElementsToRemove.isEmpty()) {
                ea.removeAll(ElementType.Reference, referenceElementsToRemove);
                if (ea.isEmpty()) {
                    return "Cannot copy reference elements whose parent is not copied.";
                }
            }
        }
        return null;
    }

    private Collection<Topology.Terminal> getTerminals(IElement node) {
        ArrayList<Topology.Terminal> result = new ArrayList<Topology.Terminal>();
        for (TerminalTopology tt : node.getElementClass().getItemsByClass(TerminalTopology.class)) {
            tt.getTerminals(node, result);
        }
        return result;
    }

    private Collection<Topology.Connection> getAllConnections(IElement node, Collection<Topology.Connection> result) {
        IDiagram diagram = node.getDiagram();
        Topology topology = (Topology)diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
        if (topology == null) {
            return result;
        }
        for (Topology.Terminal t : this.getTerminals(node)) {
            topology.getConnections(node, t, result);
        }
        return result;
    }

    protected void pruneAssortment(ElementAssortment ea, boolean cut) {
        ea.clear(ElementType.Edge);
        if (!cut) {
            ea.clear(ElementType.BranchPoint);
        }
    }

    private Point2D getPastePos(DiagramSelection ds, boolean updateOffsetCounter) {
        MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(0);
        if (mi == null) {
            mi = this.mouseInfo;
        }
        if (mi != null) {
            double xoff = mi.canvasPosition.getX() - ds.getCopyPos().getX();
            double yoff = mi.canvasPosition.getY() - ds.getCopyPos().getY();
            if (xoff == this.pasteOffset.getX() && yoff == this.pasteOffset.getY()) {
                double counterOffset = this.getOffsetGridSize() * (double)(updateOffsetCounter ? (this.pasteWithoutMovingGhostCounter = this.pasteWithoutMovingGhostCounter + 1) : this.pasteWithoutMovingGhostCounter);
                return new Point2D.Double(mi.canvasPosition.getX() + counterOffset, mi.canvasPosition.getY() + counterOffset);
            }
            this.pasteWithoutMovingGhostCounter = 0;
            this.pasteOffset.setLocation(xoff, yoff);
            return mi.canvasPosition;
        }
        Point2D p = ds.getCopyPos();
        double counterOffset = this.getOffsetGridSize() * (double)(updateOffsetCounter ? (this.pasteWithoutMovingGhostCounter = this.pasteWithoutMovingGhostCounter + 1) : this.pasteWithoutMovingGhostCounter);
        return new Point2D.Double(p.getX() + this.pasteOffset.getX() + counterOffset, p.getY() + this.pasteOffset.getY() + counterOffset);
    }

    private double getOffsetGridSize() {
        Double grid = (Double)this.getHint(GridPainter.KEY_GRID_SIZE);
        return grid == null || grid == 0.0 ? 1.0 : grid;
    }

    protected static boolean isConnectionOrEdge(IElement e) {
        ElementClass ec = e.getElementClass();
        return ec.containsClass(ConnectionHandler.class) || ec.containsClass(BendsHandler.class);
    }

    protected static boolean isMoveable(IElement e) {
        ElementClass ec = e.getElementClass();
        return ec.containsClass(Move.class) && ec.containsClass(Transform.class);
    }

    protected Point2D getCopyStartPos(Set<IElement> ss) {
        double mx = Double.MAX_VALUE;
        double my = Double.MAX_VALUE;
        for (IElement e : ss) {
            if (CopyPasteHandler.isConnectionOrEdge(e) || !CopyPasteHandler.isMoveable(e)) continue;
            Point2D pos = ElementUtils.getAbsolutePos((IElement)e);
            if (pos.getX() < mx) {
                mx = pos.getX();
            }
            if (!(pos.getY() < my)) continue;
            my = pos.getY();
        }
        Point2D nearest = null;
        double dist = Double.MAX_VALUE;
        for (IElement e : ss) {
            double dy;
            Point2D pos;
            double dx;
            double d;
            if (CopyPasteHandler.isConnectionOrEdge(e) || !CopyPasteHandler.isMoveable(e) || !((d = (dx = (pos = ElementUtils.getAbsolutePos((IElement)e)).getX() - mx) * dx + (dy = pos.getY() - my) * dy) < dist)) continue;
            dist = d;
            nearest = pos;
        }
        return nearest;
    }

    private void moveGhostElements(DiagramSelection ds, Point2D pastePos) {
        Point2D copyPos = ds.getCopyPos();
        double dx = pastePos.getX() - copyPos.getX();
        double dy = pastePos.getY() - copyPos.getY();
        Point2D snap = CopyPasteUtil.snap(this.getContext(), new Point2D.Double(dx, dy));
        this.ghostNode.setTransform(AffineTransform.getTranslateInstance(snap.getX(), snap.getY()));
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.ghostNode = (SingleElementNode)parent.addNode("cut/copy ghost", SingleElementNode.class);
        this.ghostNode.setZIndex(600);
        this.ghostNode.setVisible(Boolean.FALSE);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.ghostNode.remove();
    }

    void clearSG() {
        this.ghostNode.removeNodes();
        this.ghostNode.setVisible(Boolean.FALSE);
        this.ghostNodeMapper.clear();
    }

    boolean hideSG(DiagramSelection selection) {
        if (this.ghostNode.isVisible()) {
            this.ghostNode.removeNodes();
            this.ghostNode.setVisible(Boolean.FALSE);
            return true;
        }
        return false;
    }

    protected void scheduleActivateOwnerPart() {
        if (this.site == null) {
            return;
        }
        SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler.this.hasFocus = true;
                CopyPasteHandler.this.site.getPage().activate(CopyPasteHandler.this.site.getPart());
            }
        });
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMouse(MouseEvent.MouseExitEvent e) {
        DiagramSelection ds = this.getProjectSelection();
        if (!ds.isEmpty() && this.hideSG(ds)) {
            this.setDirty();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMouse(MouseEvent.MouseEnterEvent e) {
        DiagramSelection ds = this.getProjectSelection();
        if (!ds.isEmpty() && this.site != null && this.inPasteMode((MouseEvent)e)) {
            this.scheduleActivateOwnerPart();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMouse(MouseEvent.MouseMovedEvent e) {
        DiagramSelection ds = this.getProjectSelection();
        if (!ds.isEmpty()) {
            MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(0);
            if (mi != null) {
                this.mouseInfo = mi;
            }
            if (this.inPasteMode((MouseEvent)e)) {
                if (!this.hasFocus) {
                    this.scheduleActivateOwnerPart();
                }
                this.updateSG(ds);
                this.setDirty();
            } else if (this.hideSG(ds)) {
                this.setDirty();
            }
        }
        return false;
    }

    void updateSG(DiagramSelection selection) {
        MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(0);
        if (mi == null) {
            return;
        }
        this.moveGhostElements(selection, mi.canvasPosition);
        if (selection.getSourceCanvas() != this.getContext()) {
            for (IElement e : selection.getOriginalElements()) {
                INode node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                if (!(node instanceof IG2DNode)) continue;
                LocalDelegateNode delegate = this.getOrCreateNode((ParentNode<?>)this.ghostNode, ElementUtils.generateNodeId((IElement)e), (Class)LocalDelegateNode.class);
                delegate.setDelegate((IG2DNode)node);
            }
        } else {
            for (IElement e : selection.getOriginalElements()) {
                INode node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                if (node == null) continue;
                this.ghostNodeMapper.add(node);
                String nodeId = this.ghostNodeMapper.getId(node);
                LinkNode delegate = this.getOrCreateNode((ParentNode<?>)this.ghostNode, ElementUtils.generateNodeId((IElement)e), (Class)LinkNode.class);
                delegate.setDelegateId(nodeId);
            }
        }
        this.ghostNode.setVisible(Boolean.valueOf(true));
    }

    private <T extends INode> T getOrCreateNode(ParentNode<?> parentNode, String id, Class<T> clazz) {
        INode n = this.ghostNode.getNode(id);
        if (clazz.isInstance(n)) {
            return (T)((INode)clazz.cast(n));
        }
        this.ghostNode.removeNode(id);
        return (T)((INode)this.ghostNode.addNode(id, clazz));
    }

    protected boolean hasHighlight() {
        return this.highlightMode != null;
    }

    protected void removeHighlight() {
        if (this.isRemoved()) {
            return;
        }
        assert (this.getContext().getThreadAccess().currentThreadAccess());
        if (this.highlightMode != null) {
            if (!this.highlightMode.isRemoved()) {
                this.highlightMode.remove();
                this.setDirty();
            }
            this.highlightMode = null;
        }
    }

    private boolean inPasteMode(MouseEvent e) {
        return (e.stateMask & 0x80) != 0;
    }

    protected void selectedMessage(DiagramSelection ds) {
        int size = ds.getOriginalElements().size();
        StringBuilder sb = new StringBuilder();
        if (size == 0) {
            sb.append("No elements to ");
            if (ds.isCut()) {
                sb.append("cut");
            } else {
                sb.append("copy");
            }
        } else {
            if (ds.isCut()) {
                sb.append("Cut ");
            } else {
                sb.append("Copied ");
            }
            sb.append(size);
            sb.append(" element");
            if (size > 1) {
                sb.append('s');
            }
        }
        this.message(sb.toString());
    }

    protected void message(final String message) {
        if (this.statusLine == null) {
            return;
        }
        this.swtExec(new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler.this.statusLine.setMessage(message);
                CopyPasteHandler.this.statusLine.setErrorMessage(null);
            }
        });
    }

    protected void error(final String message) {
        if (this.statusLine == null) {
            return;
        }
        this.swtExec(new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler.this.statusLine.setErrorMessage(message);
            }
        });
    }

    protected void swtExec(Runnable r) {
        ThreadUtils.asyncExec((IThreadWorkQueue)SWTThread.getThreadAccess((Display)Display.getDefault()), (Runnable)r);
    }

    private MonitorPasteInput resolveInput(Set<SimanticsClipboard.Representation> content) throws DatabaseException {
        Variable var = (Variable)ClipboardUtils.accept(content, (IHintContext.Key)SimanticsKeys.KEY_VARIABLE);
        Resource diagramResource = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        Resource runtime = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        if (var == null || diagramResource == null || runtime == null) {
            return null;
        }
        return (MonitorPasteInput)Simantics.getSession().syncRequest(graph -> MonitorPasteInput.resolve(graph, diagramResource, runtime, var));
    }

    private static AffineTransform resolveMonitorTransform(ReadGraph graph, MonitorPasteInput input) throws DatabaseException {
        Resource tailNode;
        AffineTransform at = null;
        if (graph.isInstanceOf(input.elementResource, DiagramResource.getInstance((ReadGraph)graph).Connection) && (tailNode = ConnectionUtil.getConnectionTailNode(graph, input.elementResource)) != null) {
            at = DiagramGraphUtil.getAffineTransform(graph, tailNode);
        }
        if (at == null) {
            at = DiagramGraphUtil.getAffineTransform(graph, input.elementResource);
        }
        return at;
    }

    private static void writeMonitor(WriteGraph graph, MonitorPasteInput in, double x, double y, double scale) throws DatabaseException {
        Resource template;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        String suffix = Variables.getRVI((ReadGraph)graph, (Variable)in.component, (Variable)in.var);
        Resource resource = graph.newResource();
        graph.claim(resource, L0.InstanceOf, null, DIA.Monitor);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)in.diagramResource, (Resource)resource);
        Long l = (Long)graph.getPossibleRelatedValue(in.diagramResource, DIA.HasModCount, (Binding)Bindings.LONG);
        if (l == null) {
            l = 0L;
        }
        graph.claimLiteral(resource, L0.HasName, (Object)l.toString(), (Binding)Bindings.STRING);
        l = l + 1L;
        graph.claimLiteral(in.diagramResource, DIA.HasModCount, (Object)l, (Binding)Bindings.LONG);
        graph.claim(in.diagramResource, L0.ConsistsOf, resource);
        graph.claim(resource, G2D.HasHorizontalAlignment, null, G2D.Alignment_Leading);
        graph.claimLiteral(resource, DIA.HasDirection, (Object)0.0);
        graph.claim(resource, DIA.HasMonitorComponent, in.componentResource);
        graph.claimLiteral(resource, DIA.HasMonitorSuffix, (Object)suffix);
        DiagramGraphUtil.setTransform(graph, resource, new AffineTransform(scale, 0.0, 0.0, scale, x, y));
        Resource root = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)in.diaVar);
        if (root != null && (template = graph.getPossibleObject(root, DIA.HasDefaultMonitorTemplate)) != null) {
            graph.claim(in.elementResource, L0X.ObtainsProperty1, null, template);
        }
    }

    private boolean tryPasteMonitors() {
        SimanticsClipboard clipboard = Simantics.getClipboard();
        Session session = Simantics.getSession();
        ArrayList<MonitorPasteInput> inputList = new ArrayList<MonitorPasteInput>();
        for (Set content : clipboard.getContents()) {
            MonitorPasteInput in;
            block7: {
                in = this.resolveInput(content);
                if (in != null) break block7;
                return false;
            }
            try {
                inputList.add(in);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to resolve pasted monitor from clipboard Variable", (Throwable)e);
            }
        }
        if (inputList.isEmpty()) {
            return false;
        }
        MouseUtil.MouseInfo _mi = this.mouseUtil.getMouseInfo(0);
        MouseUtil.MouseInfo mi = _mi != null ? _mi : this.mouseInfo;
        session.markUndoPoint();
        try {
            session.syncRequest(graph -> {
                for (MonitorPasteInput in : inputList) {
                    AffineTransform monitorTransform = CopyPasteHandler.resolveMonitorTransform((ReadGraph)graph, in);
                    double dx = mouseInfo.canvasPosition.getX() - monitorTransform.getTranslateX();
                    double dy = mouseInfo.canvasPosition.getY() - monitorTransform.getTranslateY();
                    CopyPasteHandler.writeMonitor(graph, in, dx, dy, this.monitorScale);
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to create monitor based on clipboard variable", (Throwable)e);
        }
        return true;
    }

    private static class MonitorPasteInput {
        public final Resource diagramResource;
        public final Variable diaVar;
        public final Variable var;
        public final Variable component;
        public final Resource componentResource;
        public final Resource elementResource;

        MonitorPasteInput(Resource diagramResource, Variable diaVar, Variable var, Variable component, Resource componentResource, Resource elementResource) {
            this.diagramResource = diagramResource;
            this.diaVar = diaVar;
            this.var = var;
            this.component = component;
            this.componentResource = componentResource;
            this.elementResource = elementResource;
        }

        static MonitorPasteInput resolve(ReadGraph graph, Resource diagramResource, Resource runtimeDiagram, Variable inputVar) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            String diagramVariable = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable);
            if (diagramVariable == null) {
                return null;
            }
            Variable diaVar = Variables.getPossibleVariable((ReadGraph)graph, (String)diagramVariable);
            if (diaVar == null) {
                return null;
            }
            Variable ctx = Variables.getPossibleContext((ReadGraph)graph, (Variable)diaVar);
            if (ctx == null) {
                return null;
            }
            Variable var = Variables.switchRealization((ReadGraph)graph, (Variable)inputVar, (Variable)ctx);
            if (var == null) {
                return null;
            }
            Variable component = Variables.getChild((ReadGraph)graph, (Variable)diaVar, (Variable)var);
            if (component == null) {
                return null;
            }
            Resource componentResource = component.getPossibleRepresents(graph);
            if (componentResource == null) {
                return null;
            }
            Resource elementResource = graph.getPossibleObject(componentResource, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement);
            if (elementResource == null) {
                return null;
            }
            return new MonitorPasteInput(diagramResource, diaVar, var, component, componentResource, elementResource);
        }
    }
}

