/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.IOTableInfo;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scl.runtime.tuple.Tuple2;

public class IOTablesInfo {
    public static final IOTablesInfo EMPTY = new IOTablesInfo();
    ArrayList<IOTableInfo> tables = new ArrayList();

    public Tuple2 getBindingRef(double x, double y) {
        for (IOTableInfo table : this.tables) {
            if (x < table.x || x > table.x + table.width) continue;
            return new Tuple2((Object)table.name, (Object)((int)((y - table.y) / table.rowHeight)));
        }
        return null;
    }

    public boolean updateBinding(WriteGraph graph, DiagramResource DIA, Resource flagResource, double flagX, double flagY) throws DatabaseException {
        Tuple2 bindingRef = this.getBindingRef(flagX, flagY);
        if (bindingRef != null) {
            graph.claimLiteral(flagResource, DIA.Flag_HasIOTableBinding, (Object)((String)bindingRef.c0), (Binding)Bindings.STRING);
            graph.claimLiteral(flagResource, DIA.Flag_HasIOTableRowIndex, (Object)((Integer)bindingRef.c1), (Binding)Bindings.INTEGER);
            return true;
        }
        String currentBinding = (String)graph.getPossibleRelatedValue(flagResource, DIA.Flag_HasIOTableBinding);
        if (currentBinding != null && !currentBinding.isEmpty()) {
            graph.claimLiteral(flagResource, DIA.Flag_HasIOTableBinding, (Object)"", (Binding)Bindings.STRING);
            double[] transform = (double[])graph.getRelatedValue(flagResource, DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
            transform[4] = flagX;
            transform[5] = flagY;
            graph.claimLiteral(flagResource, DIA.HasTransform, (Object)transform);
            return true;
        }
        return false;
    }
}

