/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Point;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class SVGImage
extends org.simantics.g2d.svg.SVGImage {
    public SVGImage(String nodeIdentifier, String document, Point targetSize) {
        super(nodeIdentifier, document, targetSize);
    }

    public SVGImage(String nodeIdentifier, String document) {
        super(nodeIdentifier, document);
    }

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument, Point targetSize) {
        return new SVGFactory(nodeIdentifier, svgDocument, targetSize);
    }

    public Node init(G2DParentNode parent) {
        SVGNode node = (SVGNode)((Object)parent.getOrCreateNode(this.nodeIdentifier, SVGNode.class));
        node.setData(this.svgDocument);
        node.setTargetSize(this.targetSize);
        node.useMipMap(true);
        return node;
    }

    static class SVGFactory
    implements IFactory<Image> {
        String nodeIdentifier;
        String document;
        Point targetSize;

        public SVGFactory(String nodeIdentifier, String document) {
            this(nodeIdentifier, document, null);
        }

        public SVGFactory(String nodeIdentifier, String document, Point referenceSize) {
            if (nodeIdentifier == null) {
                throw new NullPointerException("nodeIdentifier is null");
            }
            if (document == null) {
                throw new NullPointerException("document is null");
            }
            this.nodeIdentifier = nodeIdentifier;
            this.document = document;
            this.targetSize = referenceSize;
        }

        public Image get() throws ProvisionException {
            return new SVGImage(this.nodeIdentifier, this.document, this.targetSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            SVGFactory other = (SVGFactory)obj;
            if (!this.nodeIdentifier.equals(other.nodeIdentifier)) {
                return false;
            }
            if (this.targetSize != null ? !this.targetSize.equals(other.targetSize) : other.targetSize != null) {
                return false;
            }
            return this.document.equals(other.document);
        }

        public int hashCode() {
            return this.nodeIdentifier.hashCode() * 31 + this.document.hashCode() + 123;
        }
    }
}

