/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.EdgeResource;

public class DiagramContentChanges {
    public final Map<Resource, Change> elements;
    public final Map<Resource, Change> nodes;
    public final Map<Resource, Change> connections;
    public final Map<EdgeResource, Change> connectionSegments;
    public final Map<Resource, Change> branchPoints;
    public final Map<Resource, Change> routeGraphConnections;
    public final Map<EdgeResource, Change> routeLinks;
    public final Map<Resource, Change> routeLines;
    public final Map<Resource, Change> routePoints;
    public boolean elementOrderChanged = false;
    public static final DiagramContentChanges EMPTY = new DiagramContentChanges(true);

    private DiagramContentChanges(boolean empty) {
        this.elements = Collections.emptyMap();
        this.nodes = Collections.emptyMap();
        this.connections = Collections.emptyMap();
        this.connectionSegments = Collections.emptyMap();
        this.branchPoints = Collections.emptyMap();
        this.routeGraphConnections = Collections.emptyMap();
        this.routeLinks = Collections.emptyMap();
        this.routeLines = Collections.emptyMap();
        this.routePoints = Collections.emptyMap();
    }

    public DiagramContentChanges() {
        this.elements = new THashMap();
        this.nodes = new THashMap();
        this.connections = new THashMap();
        this.connectionSegments = new THashMap();
        this.branchPoints = new THashMap();
        this.routeGraphConnections = new THashMap();
        this.routeLinks = new THashMap();
        this.routeLines = new THashMap();
        this.routePoints = new THashMap();
    }

    public void markElementOrderChanged() {
        this.elementOrderChanged = true;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty() && this.nodes.isEmpty() && this.connections.isEmpty() && this.connectionSegments.isEmpty() && this.branchPoints.isEmpty() && this.routeGraphConnections.isEmpty() && this.routeLinks.isEmpty() && this.routeLines.isEmpty() && this.routePoints.isEmpty() && !this.elementOrderChanged;
    }

    public <T> Set<T> pick(Map<T, Change> map, Change change) {
        HashSet<T> result = new HashSet<T>();
        for (Map.Entry<T, Change> entry : map.entrySet()) {
            if (entry.getValue() != change) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[elements=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.elements)));
        sb.append(", nodes=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.nodes)));
        sb.append(", connection=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.connections)));
        sb.append(", connection segments=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.connectionSegments)));
        sb.append(", branch points=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.branchPoints)));
        sb.append(", routegraph connections=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.routeGraphConnections)));
        sb.append(", route links=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.routeLinks)));
        sb.append(", route lines=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.routeLines)));
        sb.append(", route points=");
        sb.append(DiagramContentChanges.toString(DiagramContentChanges.count(this.routePoints)));
        sb.append(", element order changed=");
        sb.append(this.elementOrderChanged);
        sb.append("]");
        return sb.toString();
    }

    private static String toString(int[] changes) {
        return "[" + Change.ADDED.toString() + "=" + changes[Change.ADDED.ordinal()] + ", " + Change.REMOVED.toString() + "=" + changes[Change.REMOVED.ordinal()] + "]";
    }

    private static int[] count(Map<?, Change> map) {
        int[] result = new int[Change.values().length];
        for (Change change : map.values()) {
            int n = change.ordinal();
            result[n] = result[n] + 1;
        }
        return result;
    }
}

