/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DefinedElementHandler
implements SceneGraph,
InternalSize,
Resize,
Outline {
    private static final long serialVersionUID = -2074850877791708846L;
    public static final DefinedElementHandler INSTANCE = new DefinedElementHandler();
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "IMAGE_SG_NODE");

    protected Image getImage(IElement e) {
        Image i = (Image)e.getHint(ElementHints.KEY_IMAGE);
        if (i == null) {
            throw new IllegalStateException("element " + String.valueOf(e) + " has no ElementHints.KEY_IMAGE hint");
        }
        return i;
    }

    protected IHintContext.Key getNodeKey() {
        return KEY_SG_NODE;
    }

    public void init(IElement e, G2DParentNode parent) {
        Image i = this.getImage(e);
        Node node = i.init(parent);
        if (node != null) {
            e.setHint(this.getNodeKey(), (Object)node);
        }
        if (node instanceof IG2DNode) {
            IG2DNode n = (IG2DNode)node;
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            if (at != null) {
                n.setTransform(at);
            }
        }
        if (parent instanceof SingleElementNode) {
            ((SingleElementNode)parent).setParameters(ElementUtils.getParameters((IElement)e));
        }
    }

    public void cleanup(IElement e) {
        Node node = (Node)e.removeHint(this.getNodeKey());
        if (node != null) {
            node.remove();
        }
    }

    protected Rectangle2D imageBounds(IElement e, Rectangle2D size) {
        Image i = (Image)e.getHint(ElementHints.KEY_IMAGE);
        if (i == null) {
            return size;
        }
        Rectangle2D r = i.getBounds();
        if (r != null) {
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            size.setFrame(r);
        }
        return size;
    }

    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        ElementClass ec = e.getElementClass();
        if (ec.containsClass(ConnectionHandler.class)) {
            size = this.imageBounds(e, size);
        } else {
            Rectangle2D r;
            IG2DNode node = (IG2DNode)e.getHint(this.getNodeKey());
            Rectangle2D rectangle2D = r = node != null ? node.getBoundsInLocal() : null;
            if (r != null) {
                if (size == null) {
                    size = new Rectangle2D.Double();
                }
                size.setFrame(r);
            } else {
                size = this.imageBounds(e, size);
            }
        }
        return size;
    }

    public Double getFixedAspectRatio(IElement e) {
        Image i = this.getImage(e);
        Rectangle2D r = i.getBounds();
        return r.getWidth() / r.getHeight();
    }

    public Rectangle2D getMaximumSize(IElement e) {
        Image i = this.getImage(e);
        return i.getBounds();
    }

    public Rectangle2D getMinimumSize(IElement e) {
        Image i = this.getImage(e);
        return i.getBounds();
    }

    public void resize(IElement e, Rectangle2D newSize) {
    }

    public Shape getElementShape(IElement e) {
        Rectangle2D bounds;
        IG2DNode node = (IG2DNode)e.getHint(this.getNodeKey());
        if (node != null && (bounds = node.getBoundsInLocal()) != null) {
            return bounds;
        }
        Image i = this.getImage(e);
        return i.getOutline();
    }
}

