/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.common.request.BinaryAsyncRead;
import org.simantics.db.common.request.SafeName;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.CompositeImage;
import org.simantics.diagram.adapter.DefinedElementHandler;
import org.simantics.diagram.adapter.DefinedElementTerminals;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.GetElementClassRequest;
import org.simantics.diagram.adapter.NodeRequest;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.DefaultParameters;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.PlainElementPropertySetter;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.tooltip.TerminalTooltipProvider;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.Container;

public class DefinedElementFactory
extends ElementFactoryAdapter {
    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, final AsyncProcedure<ElementClass> procedure) {
        graph.asyncRequest((AsyncRead)new ClassRequest(elementType, canvas, diagram), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                t.printStackTrace();
                procedure.exception(graph, t);
            }

            public void execute(AsyncReadGraph graph, ElementClass result) {
                procedure.execute(graph, (Object)result);
            }
        });
    }

    public static void createzz(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram, final Resource elementType, final AsyncProcedure<ElementClass> procedure) {
        StructuralResource2 sr = (StructuralResource2)graph.getService(StructuralResource2.class);
        final G2DResource g2d = (G2DResource)graph.getService(G2DResource.class);
        final DiagramResource dr = (DiagramResource)graph.getService(DiagramResource.class);
        graph.forSingleObject(elementType, sr.IsDefinedBy, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                graph.asyncRequest((Read)new SafeName(elementType), (Procedure)new ProcedureAdapter<String>(){

                    public void execute(String result) {
                        System.out.println("DefinedElement '" + result + " ' does not have a single IsDefinedBy relation");
                    }
                });
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource definingResource) {
                graph.asyncRequest((AsyncRead)new NodeRequest(canvas, diagram, definingResource, null), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        throwable.printStackTrace();
                    }

                    public void execute(AsyncReadGraph graph, IElement e) {
                        final CompositeImage img = new CompositeImage(Collections.singletonList(e));
                        final ConcurrentLinkedQueue terminals = new ConcurrentLinkedQueue();
                        final AtomicInteger ready = new AtomicInteger(1);
                        graph.forOrderedSet(definingResource, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, final Resource r) {
                                ready.incrementAndGet();
                                graph.forIsInstanceOf(r, dr.Terminal, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        throwable.printStackTrace();
                                    }

                                    public void execute(AsyncReadGraph graph, Boolean isTerminal) {
                                        if (isTerminal.booleanValue()) {
                                            graph.asyncRequest((AsyncRead)new NodeRequest(canvas, diagram, r, null), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                    throwable.printStackTrace();
                                                }

                                                public void execute(AsyncReadGraph graph, final IElement t) {
                                                    graph.forPossibleRelatedValue(r, g2d.HasTransform, (Binding)Bindings.DOUBLE_ARRAY, (AsyncProcedure)new AsyncProcedure<double[]>(){

                                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                            throwable.printStackTrace();
                                                        }

                                                        public void execute(AsyncReadGraph graph, double[] mat) {
                                                            AffineTransform tr = mat != null ? new AffineTransform(mat) : new AffineTransform();
                                                            terminals.add(new ResourceTerminal(r, tr, DirectionSet.ANY, new ShapeContainer(t)));
                                                            this.worked(graph);
                                                        }
                                                    });
                                                }
                                            });
                                        } else {
                                            this.worked(graph);
                                        }
                                    }
                                });
                            }

                            public void finished(AsyncReadGraph graph) {
                                this.worked(graph);
                            }

                            void worked(AsyncReadGraph graph) {
                                if (ready.decrementAndGet() == 0) {
                                    String id = "DefinedElement: " + elementType.getResourceId();
                                    procedure.execute(graph, (Object)ElementClass.compile((ElementHandler[])new ElementHandler[]{TextImpl.INSTANCE, new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, DefaultParameters.INSTANCE, StaticSymbolImageInitializer.INSTANCE, new StaticSymbolImpl((Image)img), DefinedElementHandler.INSTANCE, new DefinedElementTerminals(terminals), SimpleElementLayers.INSTANCE, PlainElementPropertySetter.INSTANCE}).setId(id));
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public void load(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram, final Resource element, IElement e, AsyncProcedure<IElement> procedure) {
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)TransformSynchronizer.INSTANCE);
        e.setHint(TooltipParticipant.TOOLTIP_KEY, (Object)TerminalTooltipProvider.INSTANCE);
        graph.asyncRequest((Read)new PossibleAdapter(element, ElementFactory.class), (AsyncProcedure)new AsyncProcedureAdapter<ElementFactory>(){

            public void execute(AsyncReadGraph graph, ElementFactory factory) {
                if (factory != null) {
                    graph.asyncRequest((AsyncRead)new GetElementClassRequest(factory, element, canvas, diagram));
                }
            }
        });
        ElementFactoryUtil.readParameters(graph, element, e);
        GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 2);
        ElementFactoryUtil.loadLayersForElement(graph, diagram, e, element, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.readTransform(graph, element, e, (AsyncProcedure<IElement>)guard);
    }

    static class ClassRequest
    extends BinaryAsyncRead<Resource, ICanvasContext, ElementClass> {
        private final IDiagram diagram;

        public ClassRequest(Resource elementType, ICanvasContext canvas, IDiagram diagram) {
            super((Object)elementType, (Object)canvas);
            this.diagram = diagram;
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
            DefinedElementFactory.createzz(graph, (ICanvasContext)this.parameter2, this.diagram, (Resource)this.parameter, procedure);
        }
    }

    protected static class ShapeContainer
    implements Container<Shape> {
        private IElement element;
        private Shape shape = null;

        public ShapeContainer(IElement element) {
            this.element = element;
        }

        public Shape get() {
            if (this.shape == null) {
                this.shape = ElementUtils.getElementShapeOrBounds((IElement)this.element);
                this.element = null;
            }
            return this.shape;
        }
    }
}

