/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SetListener;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scenegraph.profile.common.ProfileVariables;

public class ConstantStyle
implements Style {
    final String name;
    final Map<String, Object> values = new HashMap<String, Object>();
    ObserverGroupListener listener = null;
    double priority;

    public ConstantStyle(ReadGraph graph, Resource style) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.name = (String)graph.getPossibleRelatedValue(style, L0.HasName, (Binding)Bindings.STRING);
        String[] values = (String[])graph.getPossibleRelatedValue(style, DIA.HasValues, Bindings.getBindingUnchecked(String[].class));
        int i = 0;
        while (i < values.length) {
            String key = values[i];
            Object value = this.haxx(key, values[i + 1]);
            this.values.put(key, value);
            i += 2;
        }
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getPriority() {
        return this.priority;
    }

    private Object haxx(String key, Object value) {
        if ("alpha".equals(key)) {
            return AlphaComposite.getInstance(3, Float.parseFloat((String)value));
        }
        if ("color".equals(key)) {
            return new Color(Integer.parseInt(value.toString(), 16));
        }
        return value;
    }

    public void deactivate(Resource diagram, Resource entry, Group group, EvaluationContext observer) {
        if (this.listener != null && !this.listener.isDisposed()) {
            this.listener.dispose();
            this.values.clear();
            observer.update();
        }
    }

    public void activate(RequestProcessor backend, Resource diagram, Resource entry, Group group, EvaluationContext observer) throws DatabaseException {
        if (this.listener != null && !this.listener.isDisposed()) {
            return;
        }
        this.listener = new ObserverGroupListener((Style)this, group, (Observer)observer);
        group.trackItems(backend, diagram, (SetListener)this.listener);
    }

    public void apply(Resource entry, Group group, EvaluationContext evaluationContext) {
        ICanvasContext context = (ICanvasContext)evaluationContext.getConstant(ProfileKeys.CANVAS);
        assert (context.getThreadAccess().currentThreadAccess());
        if (this.listener == null) {
            System.out.println("ConstantStyle " + String.valueOf(this) + " was not active in apply!");
            return;
        }
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        for (Map.Entry<String, Object> value : this.values.entrySet()) {
            for (Object item : this.listener.getItems()) {
                INode node = map.getNode(item);
                if (node == null) {
                    evaluationContext.update();
                    return;
                }
                ProfileVariables.claimNodeProperty((INode)node, (String)value.getKey(), (Object)value.getValue(), (EvaluationContext)evaluationContext);
            }
        }
    }

    public final void apply2(Object item, EvaluationContext evaluationContext) {
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        INode node = map.getNode(item);
        for (Map.Entry<String, Object> value : this.values.entrySet()) {
            ProfileVariables.claimNodeProperty((INode)node, (String)value.getKey(), (Object)value.getValue(), (EvaluationContext)evaluationContext);
        }
    }

    public String toString() {
        return this.name;
    }
}

