/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph.layer;

import java.util.Collection;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.SimpleLayer;

public class GraphLayer {
    public static final String PROP_VISIBLE = "PROP_VISIBLE";
    public static final String PROP_FOCUSABLE = "PROP_FOCUSABLE";
    private final String name;
    private final Resource layer;
    private boolean active;
    private final Map<String, Resource> tags;

    public GraphLayer(String name, Resource layer, Map<String, Resource> tags, boolean active) {
        this.name = name;
        this.layer = layer;
        this.tags = tags;
        this.active = active;
    }

    public GraphLayer withName(String name) {
        return new GraphLayer(name, this.layer, this.tags, this.active);
    }

    public String getName() {
        return this.name;
    }

    public Resource getLayer() {
        return this.layer;
    }

    public Resource getVisible() {
        return this.tags.get(PROP_VISIBLE);
    }

    public Resource getFocusable() {
        return this.tags.get(PROP_FOCUSABLE);
    }

    public boolean isActive() {
        return this.active;
    }

    public ILayer getILayer() {
        return new SimpleLayer(this.name);
    }

    public Collection<Resource> getTags() {
        return this.tags.values();
    }

    public void forEachTag(DbConsumer<Resource> consumer) throws DatabaseException {
        for (Resource r : this.tags.values()) {
            consumer.accept((Object)r);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphLayer other = (GraphLayer)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }
}

