/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IModelingRules;

public class SetConnectionType
extends ModificationAdapter {
    ISynchronizationContext context;
    IDiagram diagram;
    IElement element;

    public SetConnectionType(ISynchronizationContext context, IDiagram diagram, IElement element) {
        super(SET_CONNECTION_TYPE_PRIORITY);
        this.context = context;
        this.diagram = diagram;
        this.element = element;
    }

    Resource getDesiredConnectionType(IElement e) {
        Object obj = e.getHint(ElementHints.KEY_CONNECTION_TYPE);
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        if (obj instanceof ConnectionJudgement) {
            ConnectionJudgement judgement = (ConnectionJudgement)obj;
            return judgement.connectionType;
        }
        return null;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        DiagramMutator mutator = (DiagramMutator)this.diagram.getHint(DiagramHints.KEY_MUTATOR);
        IModelingRules modelingRules = (IModelingRules)this.diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        Resource connection = (Resource)mutator.backendObject(this.element);
        Resource connectionType = this.getDesiredConnectionType(this.element);
        if (connectionType != null && modelingRules != null) {
            modelingRules.setConnectionType(graph, connection, connectionType);
        }
    }
}

