/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RelativeReference;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.flag.RouteGraphConnectionSplitter;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.ElementIdentification;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class RouteGraphModification {
    int lineCount;
    int terminalCount;
    int[] links;
    ArrayList<Modi> modis = new ArrayList();
    Resource[] resources;
    String[] terminalIdentifiers;
    TObjectIntHashMap<RouteNode> idMap;
    Resource connection;

    private static void write(StringBuilder b, int[] ids) {
        b.append(ids.length);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            b.append('$');
            b.append(e);
            ++n2;
        }
    }

    private static int[] readInts(Iterator<String> it) {
        int length = Integer.parseInt(it.next());
        int[] result = new int[length];
        int i = 0;
        while (i < length) {
            result[i] = Integer.parseInt(it.next());
            ++i;
        }
        return result;
    }

    public void addModi(Modi modi) {
        this.modis.add(modi);
    }

    public RouteGraphModification(String text) {
        String[] parts = text.split(",");
        int pos = 0;
        this.lineCount = Integer.parseInt(parts[pos++]);
        this.terminalCount = Integer.parseInt(parts[pos++]);
        this.terminalIdentifiers = new String[this.terminalCount];
        int i = 0;
        while (i < this.terminalCount) {
            this.terminalIdentifiers[i] = parts[pos++];
            ++i;
        }
        int linkCount = Integer.parseInt(parts[pos++]);
        this.links = new int[2 * linkCount];
        int i2 = 0;
        while (i2 < this.links.length) {
            this.links[i2] = Integer.parseInt(parts[pos++]);
            ++i2;
        }
        while (pos < parts.length) {
            String part = parts[pos++];
            char first = part.charAt(0);
            part = part.substring(1);
            switch (first) {
                case 'M': {
                    this.addModi(new UpdateLine(part));
                    break;
                }
                case 'R': {
                    this.addModi(new RemoveLine(part));
                    break;
                }
                case 'r': {
                    this.addModi(new RemoveLink(part));
                    break;
                }
                case 'C': {
                    this.addModi(new CreateLine(part));
                    break;
                }
                case 'c': {
                    this.addModi(new CreateLink(part));
                    break;
                }
                case 'S': {
                    this.addModi(new Split(part));
                }
            }
        }
        this.resources = new Resource[this.lineCount + this.terminalCount];
    }

    public RouteGraphModification(SerialisationSupport ser, RouteGraph rg) throws DatabaseException {
        Collection lines = rg.getLines();
        this.lineCount = lines.size();
        Collection terminals = rg.getTerminals();
        this.terminalCount = terminals.size();
        this.resources = new Resource[this.lineCount + this.terminalCount];
        THashSet linkSet = new THashSet();
        this.idMap = new TObjectIntHashMap();
        int i = 0;
        for (RouteLine line : lines) {
            this.idMap.put((Object)line, i);
            this.resources[i] = ser.getResource(((Long)line.getData()).longValue());
            for (RoutePoint rp : line.getPoints()) {
                RouteLink link;
                if (!(rp instanceof RouteLink) || (link = (RouteLink)rp).getA().isTransient() || link.getA().isTransient()) continue;
                linkSet.add((Object)link);
            }
            ++i;
        }
        for (RouteTerminal terminal : terminals) {
            this.idMap.put((Object)terminal, i);
            this.resources[i] = ser.getResource(((Long)terminal.getData()).longValue());
            ++i;
        }
        if (rg.isSimpleConnection()) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.links = nArray;
        } else {
            this.links = new int[2 * (this.terminalCount + linkSet.size())];
            i = 0;
            for (RouteLink link : linkSet) {
                this.links[i++] = this.idMap.get((Object)link.getA());
                this.links[i++] = this.idMap.get((Object)link.getB());
            }
            for (RouteTerminal terminal : terminals) {
                this.links[i++] = this.idMap.get((Object)terminal);
                this.links[i++] = this.idMap.get((Object)terminal.getLine());
            }
        }
    }

    public Resource findTerminalIdentifiers(ReadGraph g) throws DatabaseException {
        Resource base = null;
        this.terminalIdentifiers = new String[this.terminalCount];
        int i = 0;
        while (i < this.terminalCount) {
            Resource r = this.resources[this.lineCount + i];
            RelativeReference ref = ElementIdentification.getConnectorIdentifier(g, r);
            this.terminalIdentifiers[i] = ref.path;
            if (ref.base != null) {
                base = ref.base;
            }
            ++i;
        }
        return base;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public void toString(StringBuilder b) {
        b.append(this.lineCount);
        b.append(',');
        b.append(this.terminalCount);
        int i = 0;
        while (i < this.terminalCount) {
            b.append(',');
            b.append(this.terminalIdentifiers[i]);
            ++i;
        }
        b.append(',');
        b.append(this.links.length / 2);
        int[] nArray = this.links;
        int n = this.links.length;
        int n2 = 0;
        while (n2 < n) {
            int l = nArray[n2];
            b.append(',');
            b.append(l);
            ++n2;
        }
        for (Modi modi : this.modis) {
            b.append(',');
            b.append(modi);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean resolveResources(ReadGraph g, Resource model) throws DatabaseException {
        void var7_13;
        void var7_11;
        void var7_8;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Resource connection = null;
        ArrayList<List<Resource>> connectorCandidates = new ArrayList<List<Resource>>(this.terminalCount);
        boolean bl = false;
        while (var7_8 < this.terminalCount) {
            connectorCandidates.add(ElementIdentification.resolveConnector(g, model, this.terminalIdentifiers[var7_8]));
            ++var7_8;
        }
        block1: for (List list : connectorCandidates) {
            if (list.isEmpty()) {
                return false;
            }
            if (connection != null || list.size() != 1) continue;
            for (Resource temp : g.getObjects((Resource)list.get(0), STR.Connects)) {
                if (!g.isInstanceOf(temp, DIA.Connection)) continue;
                connection = temp;
                continue block1;
            }
        }
        if (connection == null) {
            return false;
        }
        boolean bl2 = false;
        while (var7_11 < this.terminalCount) {
            Resource connector22;
            block25: {
                for (Resource connector22 : (List)connectorCandidates.get((int)var7_11)) {
                    if (!g.hasStatement(connector22, STR.Connects, connection)) continue;
                    break block25;
                }
                return false;
            }
            this.resources[this.lineCount + var7_11] = connector22;
            ++var7_11;
        }
        if (this.lineCount != g.getObjects(connection, DIA.HasInteriorRouteNode).size()) {
            return false;
        }
        if (this.terminalCount != g.getObjects(connection, STR.IsConnectedTo).size()) {
            return false;
        }
        if (this.lineCount == 0) {
            return true;
        }
        TObjectIntHashMap invResources = new TObjectIntHashMap();
        boolean bl3 = false;
        while (var7_13 < this.terminalCount) {
            int id = this.lineCount + var7_13;
            invResources.put((Object)this.resources[id], id);
            ++var7_13;
        }
        TIntHashSet[] tIntHashSetArray = new TIntHashSet[this.terminalCount + this.lineCount];
        int i2 = 0;
        while (i2 < tIntHashSetArray.length) {
            tIntHashSetArray[i2] = new TIntHashSet();
            ++i2;
        }
        int i = 0;
        while (i < this.links.length) {
            int a = this.links[i];
            int b = this.links[i + 1];
            if (this.resources[b] == null) {
                tIntHashSetArray[a].add(b);
            }
            if (this.resources[a] == null) {
                tIntHashSetArray[b].add(a);
            }
            i += 2;
        }
        TIntArrayList stack = new TIntArrayList();
        TIntArrayList backlog = new TIntArrayList();
        int i3 = 0;
        while (i3 < this.terminalCount) {
            stack.add(this.lineCount + i3);
            ++i3;
        }
        int oldResolvedCount = 0;
        while (invResources.size() < this.resources.length) {
            oldResolvedCount = invResources.size();
            while (!stack.isEmpty()) {
                int id = stack.removeAt(stack.size() - 1);
                TIntHashSet ns = tIntHashSetArray[id];
                int[] nArray = ns.toArray();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    if (this.resources[n3] != null) {
                        ns.remove(n3);
                    }
                    ++n2;
                }
                if (ns.isEmpty()) continue;
                if (ns.size() == 1) {
                    Resource det = null;
                    for (Resource r : g.getObjects(this.resources[id], DIA.AreConnected)) {
                        if (invResources.containsKey((Object)r)) continue;
                        if (det == null) {
                            det = r;
                            continue;
                        }
                        return false;
                    }
                    if (det == null) {
                        return false;
                    }
                    int newId = ns.iterator().next();
                    this.resources[newId] = det;
                    invResources.put((Object)det, newId);
                    stack.add(newId);
                    continue;
                }
                backlog.add(id);
            }
            if (oldResolvedCount == invResources.size()) {
                return false;
            }
            backlog.reverse();
            TIntArrayList temp = stack;
            stack = backlog;
            backlog = temp;
        }
        return true;
    }

    public Resource getConnection(ReadGraph g) throws DatabaseException {
        if (this.connection == null) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
            if (this.lineCount > 0) {
                this.connection = g.getSingleObject(this.resources[0], DIA.HasInteriorRouteNode_Inverse);
            } else {
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
                for (Resource temp : g.getObjects(this.resources[0], STR.Connects)) {
                    if (!g.isInstanceOf(temp, DIA.Connection)) continue;
                    this.connection = temp;
                    break;
                }
            }
        }
        return this.connection;
    }

    public void runUpdates(WriteGraph g) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Modi modi_ : this.modis) {
            Resource routeLine;
            Modi modi;
            if (modi_ instanceof UpdateLine) {
                modi = (UpdateLine)modi_;
                routeLine = this.resources[modi.id];
                g.claimLiteral(routeLine, DIA.HasPosition, (Object)modi.position);
                g.claimLiteral(routeLine, DIA.IsHorizontal, (Object)modi.isHorizontal);
                continue;
            }
            if (modi_ instanceof RemoveLink) {
                modi = (RemoveLink)modi_;
                g.denyStatement(this.resources[((RemoveLink)modi).a], DIA.AreConnected, this.resources[((RemoveLink)modi).b]);
                continue;
            }
            if (modi_ instanceof RemoveLine) {
                modi = (RemoveLine)modi_;
                g.deny(this.resources[((RemoveLine)modi).a]);
                continue;
            }
            if (modi_ instanceof CreateLink) {
                modi = (CreateLink)modi_;
                g.claim(this.resources[((CreateLink)modi).a], DIA.AreConnected, this.resources[((CreateLink)modi).b]);
                continue;
            }
            if (modi_ instanceof CreateLine) {
                modi = (CreateLine)modi_;
                routeLine = g.newResource();
                g.claim(routeLine, L0.InstanceOf, DIA.RouteLine);
                g.claimLiteral(routeLine, DIA.HasPosition, (Object)((CreateLine)modi).position);
                g.claimLiteral(routeLine, DIA.IsHorizontal, (Object)((CreateLine)modi).isHorizontal);
                g.claim(this.getConnection((ReadGraph)g), DIA.HasInteriorRouteNode, routeLine);
                int id = this.resources.length;
                this.resources = Arrays.copyOf(this.resources, id + 1);
                this.resources[id] = routeLine;
                continue;
            }
            if (!(modi_ instanceof Split)) continue;
            modi = (Split)modi_;
            RouteGraphConnectionSplitter splitter = new RouteGraphConnectionSplitter((ReadGraph)g);
            splitter.doSplit(g, this.connection, this.toResources(((Split)modi).interface1), this.toResources(((Split)modi).interface2), this.toResources(((Split)modi).lines2), this.toResources(((Split)modi).terminals1), this.toResources(((Split)modi).terminals2), ((Split)modi).isHorizontal, ((Split)modi).invertFlagRotation, ((Split)modi).isectX, ((Split)modi).isectY);
        }
    }

    public TObjectIntHashMap<RouteNode> getIdMap() {
        return this.idMap;
    }

    public int[] toIds(ArrayList<Resource> rs) {
        TObjectIntHashMap rmap = new TObjectIntHashMap();
        int i = 0;
        while (i < this.resources.length) {
            rmap.put((Object)this.resources[i], i);
            ++i;
        }
        int[] result = new int[rs.size()];
        int i2 = 0;
        while (i2 < rs.size()) {
            result[i2] = rmap.get((Object)rs.get(i2));
            ++i2;
        }
        return result;
    }

    public ArrayList<Resource> toResources(int[] ids) {
        ArrayList<Resource> result = new ArrayList<Resource>(ids.length);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            result.add(this.resources[id]);
            ++n2;
        }
        return result;
    }

    public static class CreateLine
    implements Modi {
        double position;
        boolean isHorizontal;

        public CreateLine(double position, boolean isHorizontal) {
            this.position = position;
            this.isHorizontal = isHorizontal;
        }

        public CreateLine(String text) {
            String[] parts = text.split("\\$");
            this.position = Double.parseDouble(parts[0]);
            this.isHorizontal = Boolean.parseBoolean(parts[1]);
        }

        public String toString() {
            return "C" + this.position + "$" + this.isHorizontal;
        }
    }

    public static class CreateLink
    implements Modi {
        int a;
        int b;

        public CreateLink(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public CreateLink(String text) {
            String[] parts = text.split("\\$");
            this.a = Integer.parseInt(parts[0]);
            this.b = Integer.parseInt(parts[1]);
        }

        public String toString() {
            return "c" + this.a + "$" + this.b;
        }
    }

    public static interface Modi {
    }

    public static class RemoveLine
    implements Modi {
        int a;

        public RemoveLine(int a) {
            this.a = a;
        }

        public RemoveLine(String text) {
            this.a = Integer.parseInt(text);
        }

        public String toString() {
            return "R" + this.a;
        }
    }

    public static class RemoveLink
    implements Modi {
        int a;
        int b;

        public RemoveLink(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public RemoveLink(String text) {
            String[] parts = text.split("\\$");
            this.a = Integer.parseInt(parts[0]);
            this.b = Integer.parseInt(parts[1]);
        }

        public String toString() {
            return "r" + this.a + "$" + this.b;
        }
    }

    public static class Split
    implements Modi {
        int[] interface1;
        int[] interface2;
        int[] lines2;
        int[] terminals1;
        int[] terminals2;
        boolean isHorizontal;
        boolean invertFlagRotation;
        double isectX;
        double isectY;

        public Split(int[] interface1, int[] interface2, int[] lines2, int[] terminals1, int[] terminals2, boolean isHorizontal, boolean invertFlagRotation, double isectX, double isectY) {
            this.interface1 = interface1;
            this.interface2 = interface2;
            this.lines2 = lines2;
            this.terminals1 = terminals1;
            this.terminals2 = terminals2;
            this.isHorizontal = isHorizontal;
            this.invertFlagRotation = invertFlagRotation;
            this.isectX = isectX;
            this.isectY = isectY;
        }

        public Split(String text) {
            List<String> parts = Arrays.asList(text.split("\\$"));
            Iterator<String> it = parts.iterator();
            this.interface1 = RouteGraphModification.readInts(it);
            this.interface2 = RouteGraphModification.readInts(it);
            this.lines2 = RouteGraphModification.readInts(it);
            this.terminals1 = RouteGraphModification.readInts(it);
            this.terminals2 = RouteGraphModification.readInts(it);
            this.isHorizontal = Boolean.parseBoolean(it.next());
            this.invertFlagRotation = Boolean.parseBoolean(it.next());
            this.isectX = Double.parseDouble(it.next());
            this.isectY = Double.parseDouble(it.next());
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("S");
            RouteGraphModification.write(b, this.interface1);
            b.append("$");
            RouteGraphModification.write(b, this.interface2);
            b.append("$");
            RouteGraphModification.write(b, this.lines2);
            b.append("$");
            RouteGraphModification.write(b, this.terminals1);
            b.append("$");
            RouteGraphModification.write(b, this.terminals2);
            b.append("$");
            b.append(this.isHorizontal);
            b.append("$");
            b.append(this.invertFlagRotation);
            b.append("$");
            b.append(this.isectX);
            b.append("$");
            b.append(this.isectY);
            return b.toString();
        }
    }

    public static class UpdateLine
    implements Modi {
        int id;
        double position;
        boolean isHorizontal;

        public UpdateLine(int id, double position, boolean isHorizontal) {
            this.id = id;
            this.position = position;
            this.isHorizontal = isHorizontal;
        }

        public UpdateLine(String text) {
            String[] parts = text.split("\\$");
            this.id = Integer.parseInt(parts[0]);
            this.position = Double.parseDouble(parts[1]);
            this.isHorizontal = Boolean.parseBoolean(parts[2]);
        }

        public String toString() {
            return "M" + this.id + "$" + this.position + "$" + this.isHorizontal;
        }
    }
}

