/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.Arrays;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;

public class PropertyModification
extends ModificationAdapter {
    private final Resource owner;
    private final Resource relation;
    private final Resource type;
    private final Object value;
    private final Binding binding;

    public PropertyModification(Resource propertyOwner, Resource propertyRelation, Resource propertyType, Object value, Binding binding) {
        super(LOW_PRIORITY);
        this.owner = propertyOwner;
        this.relation = propertyRelation;
        this.type = propertyType;
        this.value = value;
        this.binding = binding;
    }

    private final boolean arrayEquals(Object av1, Object av2) {
        boolean p2;
        if (av2 == null) {
            return false;
        }
        Class<?> c1 = av1.getClass().getComponentType();
        Class<?> c2 = av2.getClass().getComponentType();
        if (c2 == null || !c1.equals(c2)) {
            return false;
        }
        boolean p1 = c1.isPrimitive();
        if (p1 != (p2 = c2.isPrimitive())) {
            return false;
        }
        if (!p1) {
            return Arrays.equals((Object[])av1, (Object[])av2);
        }
        if (Boolean.TYPE.equals(c1)) {
            return Arrays.equals((boolean[])av1, (boolean[])av2);
        }
        if (Byte.TYPE.equals(c1)) {
            return Arrays.equals((byte[])av1, (byte[])av2);
        }
        if (Integer.TYPE.equals(c1)) {
            return Arrays.equals((int[])av1, (int[])av2);
        }
        if (Long.TYPE.equals(c1)) {
            return Arrays.equals((long[])av1, (long[])av2);
        }
        if (Float.TYPE.equals(c1)) {
            return Arrays.equals((float[])av1, (float[])av2);
        }
        if (Double.TYPE.equals(c1)) {
            return Arrays.equals((double[])av1, (double[])av2);
        }
        throw new RuntimeException("??? Contact application querySupport.");
    }

    private boolean sameValue(Object oldValue, Object newValue) {
        if (newValue.getClass().isArray()) {
            return this.arrayEquals(newValue, oldValue);
        }
        return newValue.equals(oldValue);
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        Object existing = g.getPossibleRelatedValue(this.owner, this.relation, this.binding);
        if (!this.sameValue(existing, this.value)) {
            g.markUndoPoint();
            DiagramGraphUtil.setRelatedValue(g, this.owner, this.relation, this.type, this.value, this.binding);
            CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
            g.addMetadata((Metadata)cm.add("Changed property " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.relation)));
        }
    }
}

