/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.diagram.commandlog.AddElementCommand;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;

public class AddElement
extends ModificationAdapter {
    IModifiableSynchronizationContext context;
    IDiagram diagram;
    Resource diagramResource;
    IElement element;
    Resource copyOf;

    public AddElement(IModifiableSynchronizationContext context, IDiagram d, IElement element) {
        super(ADD_NODE_PRIORITY);
        assert (context != null);
        assert (d != null);
        assert (element != null);
        this.context = context;
        this.diagram = d;
        this.diagramResource = (Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        assert (this.diagramResource != null);
        this.element = element;
        this.copyOf = (Resource)element.getHint(ElementHints.KEY_COPY_OF_OBJECT);
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        CopyAdvisor ca;
        BasicResources br = (BasicResources)this.context.get(GraphSynchronizationHints.BASIC_RESOURCES);
        DiagramMutator mutator = (DiagramMutator)this.diagram.getHint(DiagramHints.KEY_MUTATOR);
        CommonDBUtils.selectClusterSet((WriteGraph)g, (Resource)this.diagramResource);
        Resource elementClass = (Resource)ElementUtils.checkedAdapt((ElementClass)this.element.getElementClass(), Resource.class);
        ElementWriter writer = (ElementWriter)this.element.removeHint(DiagramModelHints.KEY_ELEMENT_WRITER);
        if (writer == null) {
            writer = (ElementWriter)g.adapt(elementClass, ElementWriter.class);
        }
        Resource resource = null;
        if (this.copyOf instanceof Resource && (ca = (CopyAdvisor)this.diagram.getHint(SynchronizationHints.COPY_ADVISOR)) != null) {
            Resource sourceDiagram = g.getPossibleObject(this.copyOf, Layer0.getInstance((ReadGraph)g).PartOf);
            resource = CopyAdvisorUtil.copy(this.context, g, ca, this.copyOf, sourceDiagram, this.diagramResource);
        }
        if (resource == null) {
            resource = g.newResource();
            g.claim(resource, br.L0.InstanceOf, null, elementClass);
        }
        OrderedSetUtils.add((WriteGraph)g, (Resource)this.diagramResource, (Resource)resource);
        String name = AddElement.claimFreshElementName(g, this.diagramResource, resource);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Added element " + name + " " + String.valueOf(resource) + " to composite " + String.valueOf(this.diagramResource)));
        g.claim(this.diagramResource, br.L0.ConsistsOf, resource);
        AffineTransform at = (AffineTransform)this.element.getHint(ElementHints.KEY_TRANSFORM);
        if (Commands.isRecording()) {
            Commands.record((Object)g, (Command)new AddElementCommand(this.diagramResource, resource, elementClass, name, at));
        }
        if (at != null) {
            DiagramGraphUtil.setTransform(g, resource, at);
        }
        writer.addToGraph(g, this.element, resource);
        this.element.setHint(ElementHints.KEY_OBJECT, (Object)resource);
        mutator.register(this.element, (Object)resource);
        GraphLayerManager glm = (GraphLayerManager)this.context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        if (glm != null) {
            glm.removeFromAllLayers(g, resource);
            glm.putElementOnVisibleLayers(this.diagram, g, resource);
        }
    }

    public static final String claimFreshElementName(WriteGraph graph, Resource diagram, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Long l = (Long)graph.getPossibleRelatedValue(diagram, DIA.HasModCount, (Binding)Bindings.LONG);
        if (l == null) {
            l = 0L;
        }
        String name = l.toString();
        graph.claimLiteral(element, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        l = l + 1L;
        graph.claimLiteral(diagram, DIA.HasModCount, (Object)l, (Binding)Bindings.LONG);
        return name;
    }
}

