/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolManager;
import org.simantics.project.IProject;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.disposable.IDisposable;

class SymbolManager
extends AbstractDisposable
implements ISymbolManager,
IDisposable {
    IProject project;

    public SymbolManager(IProject project) {
        this.project = project;
        project.setHint(ISymbolManager.KEY_SYMBOL_GROUPS, Collections.emptySet());
    }

    protected void doDispose() {
        this.project.setHint(KEY_SYMBOL_GROUPS, Collections.emptySet());
    }

    @Override
    public void addEntryPoints(Collection<ISymbolGroup> eps) {
        Collection groups = (Collection)this.project.getHint(KEY_SYMBOL_GROUPS);
        HashSet<ISymbolGroup> newGroups = new HashSet<ISymbolGroup>(groups);
        newGroups.addAll(eps);
        this.project.setHint(KEY_SYMBOL_GROUPS, Collections.unmodifiableCollection(newGroups));
    }

    @Override
    public void removeEntryPoints(Collection<ISymbolGroup> eps) {
        Collection groups = (Collection)this.project.getHint(KEY_SYMBOL_GROUPS);
        HashSet newGroups = new HashSet(groups);
        newGroups.removeAll(eps);
        this.project.setHint(KEY_SYMBOL_GROUPS, Collections.unmodifiableCollection(newGroups));
    }
}

