/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.simantics.db.Resource;

final class Hasher {
    private final MessageDigest md;
    private final ByteBuffer buf = ByteBuffer.wrap(new byte[128]);
    private final LongBuffer lbuf = this.buf.asLongBuffer();

    public Hasher() {
        this("SHA-256");
    }

    public Hasher(String algorithm) {
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(algorithm + " digest not supported by JVM");
        }
    }

    public void flush() {
        int pos = this.buf.position();
        if (pos > 0) {
            this.buf.position(0).limit(pos);
            this.md.update(this.buf);
            this.buf.position(0).limit(this.buf.capacity());
            this.lbuf.position(0).limit(this.lbuf.capacity());
        }
    }

    public void update(Resource r) {
        if (this.lbuf.remaining() == 0) {
            this.flush();
        }
        this.lbuf.put(r.getResourceId());
        this.buf.position(this.buf.position() + 8);
    }

    public void update(Resource r, Resource r2) {
        if (this.lbuf.remaining() < 2) {
            this.flush();
        }
        this.lbuf.put(r.getResourceId());
        this.lbuf.put(r2.getResourceId());
        this.buf.position(this.buf.position() + 16);
    }

    public void update(Resource r, Resource r2, Resource r3) {
        if (this.lbuf.remaining() < 3) {
            this.flush();
        }
        this.lbuf.put(r.getResourceId());
        this.lbuf.put(r2.getResourceId());
        this.lbuf.put(r3.getResourceId());
        this.buf.position(this.buf.position() + 24);
    }

    public void update(Resource ... rs) {
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.update(r);
            ++n2;
        }
    }

    public byte[] digest() {
        this.flush();
        return this.md.digest();
    }
}

