/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbollibrary.ISymbolGroup;

public abstract class AbstractSymbolProvider
implements ISymbolProvider {
    protected volatile boolean disposed = false;
    protected Runnable listener;
    protected Collection<ISymbolGroup> groups = Collections.emptyList();
    private Set<ISymbolGroup> groupSet = null;

    @Override
    public Collection<ISymbolGroup> getSymbolGroups() {
        return this.groups;
    }

    @Override
    public void setListener(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    void setSymbolGroup(Collection<ISymbolGroup> groups) {
        if (groups == null) {
            throw new NullPointerException("null groups");
        }
        this.groups = groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ISymbolGroup> getSymbolGroupSet() {
        AbstractSymbolProvider abstractSymbolProvider = this;
        synchronized (abstractSymbolProvider) {
            if (this.groupSet != null) {
                return this.groupSet;
            }
            this.groupSet = new HashSet<ISymbolGroup>(this.getSymbolGroups());
            return this.groupSet;
        }
    }

    void lockGroups() {
        this.groups = Collections.unmodifiableCollection(this.groups);
        this.groupSet = null;
        this.getSymbolGroupSet();
    }

    public int hashCode() {
        return this.getSymbolGroupSet().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractSymbolProvider)) {
            return false;
        }
        AbstractSymbolProvider other = (AbstractSymbolProvider)obj;
        return this.getSymbolGroupSet().equals(other.getSymbolGroupSet());
    }
}

