/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.utils.TopologicalSelectionExpander;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;

public class ExpandSelectionHandler
extends AbstractDiagramParticipant {
    private final IStatusLineManager statusLine;
    @DependencyReflection.Dependency
    Selection selection;

    public ExpandSelectionHandler(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleExpand(CommandEvent event) {
        if (Commands.EXPAND_SELECTION.equals((Object)event.command)) {
            return this.expandSelection(0);
        }
        return false;
    }

    public boolean expandSelection(int selectionId) {
        Set start = this.selection.getSelection(selectionId);
        TopologicalSelectionExpander expander = new TopologicalSelectionExpander(this.diagram, start);
        final Set expanded = expander.expandedIfChanged();
        if (expanded == null) {
            return false;
        }
        this.selection.setSelection(selectionId, (Collection)expanded);
        if (this.statusLine != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExpandSelectionHandler.this.statusLine.setMessage("Expanded selection to include " + expanded.size() + " (from " + ExpandSelectionHandler.this.diagram.getElements().size() + ") items.");
                }
            });
        }
        return true;
    }
}

