/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.strings.EString;

public class DiagramSelection {
    public static final DiagramSelection EMPTY = new DiagramSelection(null);
    private final WeakReference<ICanvasContext> sourceCanvas;
    private final Resource source;
    private final transient Set<IElement> elements;
    private final ElementObjectAssortment assortment;
    private final boolean cut;
    private final Point2D copyPos;

    private DiagramSelection(Resource source) {
        this.sourceCanvas = null;
        this.source = source;
        this.elements = Collections.emptySet();
        this.assortment = ElementObjectAssortment.fromElements(this.elements);
        this.cut = false;
        this.copyPos = new Point2D.Double();
    }

    public DiagramSelection(ICanvasContext sourceCanvas, Resource source, Set<IElement> elements, boolean cut, Point2D copyPos) {
        assert (source != null);
        assert (elements != null);
        this.sourceCanvas = new WeakReference<ICanvasContext>(sourceCanvas);
        this.source = source;
        this.elements = Collections.unmodifiableSet(elements);
        this.assortment = ElementObjectAssortment.fromElements(elements);
        this.cut = cut;
        this.copyPos = copyPos;
    }

    public ICanvasContext getSourceCanvas() {
        ICanvasContext ctx;
        ICanvasContext iCanvasContext = ctx = this.sourceCanvas == null ? null : (ICanvasContext)this.sourceCanvas.get();
        return ctx == null ? null : (ctx.isDisposed() ? null : ctx);
    }

    public boolean isFromCanvasContext(ICanvasContext ctx) {
        ICanvasContext srcCtx = this.getSourceCanvas();
        return ctx != null && ctx == srcCtx;
    }

    public Resource getSourceDiagram() {
        return this.source;
    }

    public boolean isCut() {
        return this.cut;
    }

    public Point2D getCopyPos() {
        return this.copyPos;
    }

    public Set<IElement> getOriginalElements() {
        return this.elements;
    }

    public ElementObjectAssortment getAssortment() {
        return this.assortment;
    }

    public boolean isEmpty() {
        return this.getAssortment().isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Diagram selection of ");
        sb.append(this.elements.size());
        sb.append(" element(s) ");
        if (this.cut) {
            sb.append("cut");
        } else {
            sb.append("copied");
        }
        sb.append(" from ");
        sb.append(this.source);
        sb.append(" with reference position ");
        sb.append(this.copyPos);
        if (this.elements != null && !this.elements.isEmpty()) {
            sb.append(":\n");
            String elems = EString.implode(this.elements, (String)"\n");
            if (elems != null) {
                sb.append(EString.addPrefix((String)elems, (String)"\t"));
            }
        }
        if (this.assortment != null && !this.assortment.isEmpty()) {
            sb.append(this.assortment.toString());
        }
        return sb.toString();
    }
}

