/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.diagram.handler.CopyPasteStrategy;
import org.simantics.diagram.handler.CopyPasteUtil;
import org.simantics.diagram.handler.DiagramSelection;
import org.simantics.diagram.handler.DiagramSelectionRepresentation;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.utils.ui.ErrorLogger;

public class DefaultCopyPasteStrategy
implements CopyPasteStrategy {
    @Override
    public void paste(PasteOperation op) {
        try {
            if (op.sameDiagram() && op.cut) {
                CopyPasteUtil.localCutPaste(op);
            } else {
                Session session = Simantics.getSession();
                if (CopyPasteUtil.onlyFlagsWithoutCorrespondence((RequestProcessor)session, op.ea) && CopyPasteUtil.checkFlagExternality((RequestProcessor)session, op.ea.flags, false)) {
                    CopyPasteUtil.continueFlags(op);
                } else {
                    CopyPasteUtil.performDefaultPaste(op);
                }
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public void copyToClipboard(DiagramSelection selection) {
        Simantics.setClipboard((SimanticsClipboard)new SimanticsClipboardImpl((SimanticsClipboard.Representation)new DiagramSelectionRepresentation(selection)));
    }
}

