/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.contribution;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public abstract class DiagramDynamicMenuContribution<T>
extends DynamicMenuContribution {
    private static final IContributionItem[] NONE = new IContributionItem[0];
    private ICanvasContext canvas;

    public void fill(Menu menu, int index) {
        IWorkbenchPart activePart = WorkbenchUtils.getActiveWorkbenchPart();
        if (activePart == null) {
            return;
        }
        ICanvasContext ctx = (ICanvasContext)activePart.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            return;
        }
        this.canvas = ctx;
        try {
            super.fill(menu, index);
        }
        finally {
            this.canvas = null;
        }
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        T input = this.computeInput(graph, selection);
        if (input == null) {
            return NONE;
        }
        return new IContributionItem[]{new ActionContributionItem((IAction)new Helper(graph.getSession(), this.canvas, input))};
    }

    protected ImageDescriptor silk(String name) {
        return BundleUtils.getImageDescriptorFromBundle((Bundle)Platform.getBundle((String)"com.famfamfam.silk"), (String)("/icons/" + name));
    }

    protected abstract T computeInput(ReadGraph var1, Object[] var2) throws DatabaseException;

    protected abstract void perform(Session var1, ICanvasContext var2, T var3);

    protected abstract String getName();

    protected abstract ImageDescriptor getImage();

    public class Helper
    extends Action {
        private final T input;
        protected final Session session;
        protected final ICanvasContext context;

        public Helper(Session session, ICanvasContext context, T input) {
            super(DiagramDynamicMenuContribution.this.getName(), DiagramDynamicMenuContribution.this.getImage());
            this.session = session;
            this.context = context;
            this.input = input;
        }

        public void run() {
            DiagramDynamicMenuContribution.this.perform(this.session, this.context, this.input);
            ThreadUtils.asyncExec((IThreadWorkQueue)this.context.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Helper.this.context.isDisposed()) {
                        return;
                    }
                    Selection selection = (Selection)Helper.this.context.getAtMostOneItemOfClass(Selection.class);
                    if (selection != null) {
                        selection.clear(0);
                    }
                }
            });
        }
    }
}

