/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.List;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.BaseRequest2;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.GetElementClassRequest;
import org.simantics.diagram.adapter.SpawnRequest;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.SubstituteElementClass;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRequest2
extends BaseRequest2<Resource, Tuple3> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRequest2.class);
    final IDiagram diagram;

    public NodeRequest2(ICanvasContext canvas, IDiagram diagram, Resource resource) {
        super(canvas, resource);
        this.diagram = diagram;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<Tuple3> procedure) {
        if (this.diagram == null) {
            procedure.exception(graph, (Throwable)new NullPointerException("null diagram specified for resource " + String.valueOf(this.data)));
            return;
        }
        final ErrorHandler eh = ElementFactoryUtil.getErrorHandler(this.diagram);
        graph.forHasStatement((Resource)this.data, (AsyncProcedure)new AsyncProcedure<Boolean>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                eh.error("NodeRequest.forHasStatement failed", throwable);
                procedure.execute(graph, null);
            }

            public void execute(AsyncReadGraph graph, Boolean result) {
                if (!result.booleanValue()) {
                    procedure.execute(graph, null);
                    return;
                }
                graph.asyncRequest((Read)new Adapter((Resource)NodeRequest2.this.data, ElementFactory.class), (AsyncListener)new TransientCacheAsyncListener<ElementFactory>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        eh.error("NodeRequest.asyncRequest(Adapter<ElementFactory>) failed", throwable);
                        procedure.execute(graph, null);
                    }

                    public void execute(AsyncReadGraph graph, final ElementFactory factory) {
                        graph.asyncRequest((AsyncRead)new GetElementClassRequest(factory, (Resource)(this).NodeRequest2.this.data, (this).NodeRequest2.this.canvas, (this).NodeRequest2.this.diagram), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                LOGGER.error("Unexpected error in GetElementClassRequest", throwable);
                                procedure.execute(graph, null);
                            }

                            public void execute(AsyncReadGraph graph, ElementClass mutableClazz) {
                                List substitutes = ((this).this).NodeRequest2.this.diagram.getDiagramClass().getItemsByClass(SubstituteElementClass.class);
                                for (SubstituteElementClass subs : substitutes) {
                                    mutableClazz = subs.substitute(((this).this).NodeRequest2.this.diagram, mutableClazz);
                                }
                                final ElementClass clazz = mutableClazz;
                                graph.asyncRequest((AsyncRead)new SpawnRequest(((this).this).NodeRequest2.this.canvas, clazz, (Resource)((this).this).NodeRequest2.this.data), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        LOGGER.error("Unexpected error in SpawnRequest", throwable);
                                        procedure.execute(graph, null);
                                    }

                                    public void execute(AsyncReadGraph graph, IElement element) {
                                        procedure.execute(graph, (Object)new Tuple3((Object)element, (Object)clazz, (Object)factory));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }
}

